/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.plans;

import jadex.planlib.TestReport;
import jadex.runtime.IEvent;
import jadex.runtime.IFilter;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SUtil;

public class WaitqueueTestPlan
extends Plan {
    public void body() {
        boolean success = true;
        TestReport tr = new TestReport("#1", "Sending request and waiting for answers (bulk handling).");
        this.getLogger().info("Test 1: Sending request and waiting for answers.");
        IMessageEvent request = this.createMessageEvent("rp_initiate");
        request.getParameterSet("receivers").addValue((Object)this.getScope().getAgentIdentifier());
        request.getParameter("reply-with").setValue((Object)"some reply id");
        this.getWaitqueue().addReply(request);
        IFilter filter = this.sendMessage(request);
        this.waitFor(2000L);
        IEvent[] answers = this.getWaitqueue().getEvents(filter);
        this.getWaitqueue().removeReply(request);
        if (answers.length != 5) {
            tr.setReason("Received wrong number of answers (should be 5): " + answers.length + "\n" + SUtil.arrayToString((Object)answers));
            this.getLogger().severe("Received wrong number of answers (should be 5): " + answers.length + "\n" + SUtil.arrayToString((Object)answers));
        } else {
            tr.setSucceeded(true);
            this.getLogger().info("Received all answers: " + answers.length + "\n" + SUtil.arrayToString((Object)answers));
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#2", "Sending request and waiting for answers (iterative handling).");
        this.getLogger().info("\n\nTest 2: Sending request and waiting for answers.");
        request = this.createMessageEvent("rp_initiate");
        request.getParameterSet("receivers").addValue((Object)this.getScope().getAgentIdentifier());
        request.getParameter("reply-with").setValue((Object)"some other reply id");
        filter = this.sendMessage(request);
        this.getWaitqueue().addFilter(filter);
        this.waitFor(2000L);
        int cnt = 0;
        IEvent answer = this.waitFor(filter, 100L);
        while (answer != null) {
            if (!((IMessageEvent)answer).getContent().equals("" + ++cnt)) {
                success = false;
                this.getLogger().severe("Wrong answer #" + cnt + " received: " + answer);
            } else {
                this.getLogger().info("Received answer #" + cnt + ": " + answer);
            }
            try {
                answer = this.waitFor(filter, 100L);
            }
            catch (TimeoutException e) {
                answer = null;
            }
        }
        this.getWaitqueue().removeFilter(filter);
        if (cnt != 5) {
            success = false;
            tr.setReason("Received wrong number of answers (should be 5): " + cnt);
            this.getLogger().severe("Received wrong number of answers (should be 5): " + cnt);
        } else {
            tr.setSucceeded(true);
            this.getLogger().info("Received all answers: " + cnt);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        if (success) {
            this.getLogger().info("All tests succeded.");
        } else {
            this.getLogger().severe("Some tests failed.");
        }
    }
}

