/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.plans;

import jadex.planlib.TestReport;
import jadex.runtime.Plan;

public class WaitForMaxLongPlan
extends Plan {
    public void body() {
        int cnt = (Integer)this.getBeliefbase().getBelief("cnt").getFact();
        this.getBeliefbase().getBelief("cnt").setFact((Object)new Integer(cnt + 1));
        switch (cnt) {
            case 0: {
                this.testWait(300L, new TestReport("test_wait_before", "Test if waitFor(Long.MAX_VALUE) disturbs earlier waitFor-statements."));
                break;
            }
            case 1: {
                this.testWait(Long.MAX_VALUE, null);
                break;
            }
            case 2: {
                this.testWait(300L, new TestReport("test_wait_after", "Test if waitFor(Long.MAX_VALUE) disturbs later waitFor-statements."));
                break;
            }
            default: {
                this.fail();
            }
        }
    }

    protected void testWait(long wait, TestReport tr) {
        this.getLogger().info("Now waiting for " + wait + " ms");
        this.waitFor(wait);
        this.getLogger().info("Finished waiting");
        if (tr != null) {
            tr.setSucceeded(true);
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        }
    }
}

