/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.plans;

import jadex.planlib.TestReport;
import jadex.runtime.IFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;

public class TimeoutExceptionPlan
extends Plan {
    protected TestReport tr;

    public void body() {
        TestReport tr = new TestReport("#1", "Test normal timed wait.");
        long start = System.currentTimeMillis();
        long test = 200L;
        this.waitFor(test);
        long dur = System.currentTimeMillis() - start;
        double diff = (double)Math.abs(dur - test) / (double)test * 100.0;
        if (diff < 5.0) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Difference greater than 5 percent: " + diff);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#2", "Testing timeout with catch.");
        try {
            this.waitFor(IFilter.NEVER, 200L);
            tr.setReason("No timeout exception occurred.");
        }
        catch (TimeoutException e) {
            tr.setSucceeded(true);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.tr = new TestReport("#3", "Testing timeout without catch.");
        this.waitFor(IFilter.NEVER, 200L);
        this.tr.setReason("No timeout exception occurred.");
    }

    public void failed() {
        this.tr.setSucceeded(true);
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)this.tr);
    }
}

