/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.plans;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IFilter;
import jadex.runtime.Plan;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.plans.ExecutePlanStepAction;
import jadex.runtime.planwrapper.ElementWrapper;

public class TestAbortPlan
extends Plan {
    public void body() {
        this.getLogger().info("Waiting: " + (Object)((Object)this));
        this.waitFor(IFilter.NEVER);
    }

    public void aborted() {
        this.getLogger().info("Plan aborting...");
        RCapability scope = (RCapability)((ElementWrapper)this.getScope()).unwrap();
        RPlan rplan = scope.getPlanbase().getPlan(this.getName());
        TestReport tr = new TestReport("#1", "Tests plan abortion.");
        IAgendaAction action = scope.getAgent().getInterpreter().getCurrentAgendaEntry().getAction();
        if (action instanceof ExecutePlanStepAction && ((ExecutePlanStepAction)action).getPlan().equals(rplan)) {
            tr.setSucceeded(true);
        } else {
            tr.setFailed("aborted() not executed during corresponding plan cleanup action.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Waiting in abort...");
        this.waitFor(50L);
        this.getLogger().info("Waiting finished...");
        tr = new TestReport("#2", "Tests waitFor() in plan abortion.");
        action = scope.getAgent().getInterpreter().getCurrentAgendaEntry().getAction();
        if (action instanceof ExecutePlanStepAction && ((ExecutePlanStepAction)action).getPlan().equals(rplan)) {
            tr.setSucceeded(true);
        } else {
            tr.setFailed("aborted() not executed during corresponding plan cleanup action.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Successful subgoal in abort...");
        tr = new TestReport("#3", "Tests successful subgoal in plan abortion.");
        try {
            this.dispatchSubgoalAndWait(this.createGoal("successgoal"));
            tr.setSucceeded(true);
            this.getLogger().info("Goal succeeded...");
        }
        catch (GoalFailureException gfe) {
            tr.setFailed("Goal failed when expected to succeed.");
            this.getLogger().info("Goal failed...");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Failed subgoal in abort...");
        tr = new TestReport("#4", "Tests failed subgoal in plan abortion.");
        try {
            this.dispatchSubgoalAndWait(this.createGoal("failuregoal"));
            tr.setFailed("Goal succeeded when expected to fail.");
            this.getLogger().info("Goal succeeded...");
        }
        catch (GoalFailureException gfe) {
            tr.setSucceeded(true);
            this.getLogger().info("Goal failed...");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Succesful subgoal with plan in abort...");
        tr = new TestReport("#5", "Tests successful subgoal with plan in plan abortion.");
        try {
            this.dispatchSubgoalAndWait(this.createGoal("successgoal2"));
            tr.setSucceeded(true);
            this.getLogger().info("Goal succeeded...");
        }
        catch (GoalFailureException gfe) {
            tr.setFailed("Goal failed when expected to succeed.");
            this.getLogger().info("Goal failed...");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Failed subgoal with plan in abort...");
        tr = new TestReport("#6", "Tests failed subgoal with plan in plan abortion.");
        try {
            this.dispatchSubgoalAndWait(this.createGoal("failuregoal2"));
            tr.setFailed("Goal succeeded when expected to fail.");
            this.getLogger().info("Goal succeeded...");
        }
        catch (GoalFailureException gfe) {
            tr.setSucceeded(true);
            this.getLogger().info("Goal failed...");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

