/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.plans;

import jadex.planlib.TestReport;
import jadex.runtime.Plan;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.agenda.IAgendaEntry;

public class MicroStepPlan
extends Plan {
    public void body() {
        TestReport tr = new TestReport("#1", "Testing micro steps. There are 3 conditions a, b, and(a,b) that should trigger immediately.");
        this.getLogger().info("Testing micro steps. There are 3 conditions a, b, and(a,b) that should trigger immediately.");
        int plan_cnt1 = this.getPlanbase().getPlans().length;
        this.getLogger().info("Plan: Setting a to true.");
        this.getBeliefbase().getBelief("a").setFact((Object)new Boolean(true));
        int plan_cnt2 = this.getPlanbase().getPlans().length;
        this.getLogger().info("Plan: a is now true.");
        this.getLogger().info("Plan: Setting b to true.");
        this.getBeliefbase().getBelief("b").setFact((Object)new Boolean(true));
        int plan_cnt3 = this.getPlanbase().getPlans().length;
        this.getLogger().info("Plan: b is now true.");
        this.getLogger().info("Step 1 finished.");
        if (plan_cnt1 < plan_cnt2 && plan_cnt2 < plan_cnt3) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("No micro plan step occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.waitFor(100L);
        tr = new TestReport("#2", "Resetting beliefs. As conditions should not trigger, plan will not be interrupted (use introspector to check");
        this.getLogger().info("\nResetting beliefs. As conditions should not trigger, plan will not be interrupted (use introspector to check).");
        this.getLogger().info("Plan: Setting a to false.");
        IAgendaEntry entry1 = ((RCapability)this.getRPlan().getOwner().getOwner()).getAgent().getInterpreter().getCurrentAgendaEntry();
        this.getBeliefbase().getBelief("a").setFact((Object)new Boolean(false));
        IAgendaEntry entry2 = ((RCapability)this.getRPlan().getOwner().getOwner()).getAgent().getInterpreter().getCurrentAgendaEntry();
        this.getLogger().info("Plan: a is now false.");
        this.getLogger().info("Plan: Setting b to false.");
        this.getBeliefbase().getBelief("b").setFact((Object)new Boolean(false));
        IAgendaEntry entry3 = ((RCapability)this.getRPlan().getOwner().getOwner()).getAgent().getInterpreter().getCurrentAgendaEntry();
        this.getLogger().info("Plan: b is now false.");
        this.getLogger().info("Step 2 finished.");
        if (entry1 == entry2 && entry2 == entry3) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Micro plan step occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.waitFor(100L);
        this.startAtomic();
        tr = new TestReport("#3", "Testing atomic step. There are 3 conditions a, b, and(a,b) that should trigger after the plan step has finished.");
        this.getLogger().info("\nTesting atomic step. There are 3 conditions a, b, and(a,b) that should trigger after the plan step has finished.");
        this.getLogger().info("Plan: Setting a to true.");
        plan_cnt1 = this.getPlanbase().getPlans().length;
        this.getBeliefbase().getBelief("a").setFact((Object)new Boolean(true));
        plan_cnt2 = this.getPlanbase().getPlans().length;
        this.getLogger().info("Plan: a is now true.");
        this.getLogger().info("Plan: Setting b to true.");
        this.getBeliefbase().getBelief("b").setFact((Object)new Boolean(true));
        plan_cnt3 = this.getPlanbase().getPlans().length;
        this.getLogger().info("Plan: b is now true.");
        this.getLogger().info("Step 3 finished.");
        if (plan_cnt1 == plan_cnt2 && plan_cnt2 == plan_cnt3) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Micro plan step occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.endAtomic();
    }
}

