/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.plans;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.IInternalEvent;
import jadex.runtime.Plan;

public class MLRSortTesterPlan
extends Plan {
    public void body() {
        TestReport tr = new TestReport("#1", "Test if meta-level reasoning works for goals.");
        IGoal ag = this.createGoal("app_goal");
        try {
            this.dispatchSubgoalAndWait(ag);
        }
        catch (GoalFailureException e) {
            // empty catch block
        }
        this.validateTestResult(tr);
        tr = new TestReport("#2", "Test if meta-level reasoning works for internal events.");
        IInternalEvent tie = this.createInternalEvent("testinternalevent");
        this.dispatchInternalEvent(tie);
        this.waitFor(100L);
        this.validateTestResult(tr);
        tr = new TestReport("#3", "Test if meta-level reasoning works for filters.");
        IInternalEvent tf = this.createInternalEvent("testfilter");
        this.dispatchInternalEvent(tf);
        this.waitFor(100L);
        this.validateTestResult(tr);
    }

    protected void validateTestResult(TestReport tr) {
        Double[] plans = (Double[])this.getBeliefbase().getBeliefSet("plans").getFacts();
        boolean succ = plans.length > 0;
        for (int i = 0; succ && i < plans.length - 1; ++i) {
            succ = plans[i] >= plans[i + 1];
        }
        if (succ) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Meta-level reasoning error.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getBeliefbase().getBeliefSet("plans").removeFacts();
    }
}

