/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.planlib.TestReport;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;

public class WaitForPlan
extends Plan
implements Runnable {
    boolean thread_finished;

    public void body() {
        long newt;
        TestReport report = new TestReport("time", "Waiting for 100 ms.");
        this.waitFor(100L);
        report.setSucceeded(true);
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("beliefchange", "Waiting for belief 'time' to change.");
        long oldt = (Long)this.getBeliefbase().getBelief("time").getFact();
        try {
            this.waitForBeliefChange("time", 200L);
            newt = (Long)this.getBeliefbase().getBelief("time").getFact();
            if (newt != oldt) {
                report.setSucceeded(true);
            } else {
                report.setReason("No change in belief detected.");
            }
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("condition", "Waiting for a condition to become true.");
        oldt = (Long)this.getBeliefbase().getBelief("time").getFact();
        try {
            this.waitForCondition("$beliefbase.time>" + (oldt + 100L) + "L", 300L);
            newt = (Long)this.getBeliefbase().getBelief("time").getFact();
            if (newt > oldt + 100L) {
                report.setSucceeded(true);
            } else {
                report.setReason("Condition does not hold.");
            }
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("truecondition", "Waiting for a condition that is initially true.");
        try {
            this.waitForCondition("true", 100L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("goal", "Waiting for a goal to complete.");
        IGoal goal = this.getGoalbase().createGoal("test");
        try {
            this.dispatchSubgoalAndWait(goal, 100L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("message", "Waiting for a message reply.");
        IMessageEvent me = this.createMessageEvent("default_query_ping");
        me.getParameterSet("receivers").addValue((Object)this.getScope().getAgentIdentifier());
        try {
            this.sendMessageAndWait(me, 200L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("timeout", "Waiting for a timeout.");
        try {
            IMessageEvent rep = this.waitForMessageEvent("query_ping", 100L);
            report.setReason("Received message: " + rep);
        }
        catch (TimeoutException e) {
            report.setSucceeded(true);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        new Thread(this).start();
        while (!this.thread_finished) {
            this.waitFor(100L);
        }
    }

    public void run() {
        long newt;
        long oldt;
        TestReport report = new TestReport("x-time", "Waiting for 100 ms.");
        this.getExternalAccess().waitFor(100L);
        report.setSucceeded(true);
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("x-beliefchange", "Waiting for belief 'time' to change.");
        try {
            this.getExternalAccess().waitForBeliefChange("time", 500L);
            oldt = (Long)this.getExternalAccess().getBeliefbase().getBelief("time").getFact();
            this.getExternalAccess().waitForBeliefChange("time", 500L);
            newt = (Long)this.getExternalAccess().getBeliefbase().getBelief("time").getFact();
            if (newt != oldt) {
                report.setSucceeded(true);
            } else {
                report.setReason("No change in belief detected: " + oldt + " " + newt);
            }
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("x-condition", "Waiting for a condition to become true.");
        oldt = (Long)this.getExternalAccess().getBeliefbase().getBelief("time").getFact();
        try {
            this.getExternalAccess().waitForCondition("$beliefbase.time>" + (oldt + 100L) + "L", 300L);
            newt = (Long)this.getExternalAccess().getBeliefbase().getBelief("time").getFact();
            if (newt > oldt + 100L) {
                report.setSucceeded(true);
            } else {
                report.setReason("Condition does not hold.");
            }
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("x-truecondition", "Waiting for a condition that is initially true.");
        try {
            this.getExternalAccess().waitForCondition("true", 100L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("x-goal", "Waiting for a goal to complete.");
        IGoal goal = this.getExternalAccess().getGoalbase().createGoal("test");
        try {
            this.getExternalAccess().dispatchTopLevelGoalAndWait(goal, 100L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("x-message", "Waiting for a message reply.");
        IMessageEvent me = this.getExternalAccess().createMessageEvent("default_query_ping");
        me.getParameterSet("receivers").addValue((Object)this.getExternalAccess().getAgentIdentifier());
        try {
            this.getExternalAccess().sendMessageAndWait(me, 100L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Timeout occurred.");
        }
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("x-timeout", "Waiting for a timeout.");
        try {
            IMessageEvent rep = this.getExternalAccess().waitForMessageEvent("query_ping", 100L);
            report.setReason("Received message: " + rep);
        }
        catch (TimeoutException e) {
            report.setSucceeded(true);
        }
        this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        this.thread_finished = true;
    }
}

