/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.planlib.TestReport;
import jadex.runtime.IElement;
import jadex.runtime.IGoal;
import jadex.runtime.IInternalEvent;
import jadex.runtime.Plan;

public class ParameterProtectionPlan
extends Plan {
    public void body() {
        IInternalEvent event = this.createInternalEvent("test_event");
        this.testInit((IElement)event);
        this.startAtomic();
        this.dispatchInternalEvent(event);
        this.testInProcess((IElement)event);
        this.endAtomic();
        IGoal subgoal = this.createGoal("test_goal");
        this.testInit((IElement)subgoal);
        this.startAtomic();
        this.getWaitqueue().addSubgoal(subgoal);
        this.dispatchSubgoal(subgoal);
        this.testInProcess((IElement)subgoal);
        this.endAtomic();
        this.waitForSubgoal(subgoal, 1000L);
        this.getWaitqueue().removeGoal(subgoal);
        this.testInit((IElement)subgoal);
    }

    protected void testInit(IElement elem) {
        TestReport report = new TestReport("init-read-in", "Testing init-protected read access of in parameter.");
        try {
            this.getParameterValue(elem, "param_in");
            report.setReason("Could read forbidden parameter.");
        }
        catch (Exception e) {
            report.setSucceeded(true);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("init-read-inout", "Testing init-protected read access of inout parameter.");
        try {
            this.getParameterValue(elem, "param_inout");
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not read unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("init-read-out", "Testing init-protected read access of out parameter.");
        try {
            this.getParameterValue(elem, "param_out");
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not read unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        String newvalue = "newvalue";
        report = new TestReport("init-write-in", "Testing init-protected write access of in parameter.");
        try {
            this.setParameterValue(elem, "param_in", newvalue);
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not write unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("init-write-inout", "Testing init-protected write access of inout parameter.");
        try {
            this.setParameterValue(elem, "param_inout", newvalue);
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not write unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("init-write-out", "Testing init-protected write access of out parameter.");
        try {
            this.setParameterValue(elem, "param_out", newvalue);
            report.setReason("Could write forbidden parameter.");
        }
        catch (Exception e) {
            report.setSucceeded(true);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
    }

    protected void testInProcess(IElement elem) {
        TestReport report = new TestReport("process-read-in", "Testing process-protected read access of in parameter.");
        try {
            this.getParameterValue(elem, "param_in");
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not read unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("process-read-inout", "Testing process-protected read access of inout parameter.");
        try {
            this.getParameterValue(elem, "param_inout");
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not read unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("process-read-out", "Testing process-protected read access of out parameter.");
        try {
            this.getParameterValue(elem, "param_out");
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not read unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        String newvalue = "newvalue";
        report = new TestReport("process-write-in", "Testing process-protected write access of in parameter.");
        try {
            this.setParameterValue(elem, "param_in", newvalue);
            report.setReason("Could write forbidden parameter.");
        }
        catch (Exception e) {
            report.setSucceeded(true);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("process-write-inout", "Testing process-protected write access of inout parameter.");
        try {
            this.setParameterValue(elem, "param_inout", newvalue);
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not write unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("process-write-out", "Testing process-protected write access of out parameter.");
        try {
            this.setParameterValue(elem, "param_out", newvalue);
            report.setSucceeded(true);
        }
        catch (Exception e) {
            report.setReason("Could not write unforbidden parameter.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
    }

    protected Object getParameterValue(IElement element, String name) {
        if (element instanceof IGoal) {
            return ((IGoal)element).getParameter(name).getValue();
        }
        return ((IInternalEvent)element).getParameter(name).getValue();
    }

    protected void setParameterValue(IElement element, String name, Object value) {
        if (element instanceof IGoal) {
            ((IGoal)element).getParameter(name).setValue(value);
        } else {
            ((IInternalEvent)element).getParameter(name).setValue(value);
        }
    }

    protected Object[] getParameterSetValues(IElement element, String name) {
        if (element instanceof IGoal) {
            return ((IGoal)element).getParameterSet(name).getValues();
        }
        return ((IInternalEvent)element).getParameterSet(name).getValues();
    }

    protected void addParameterSetValue(IElement element, String name, Object value) {
        if (element instanceof IGoal) {
            ((IGoal)element).getParameterSet(name).addValue(value);
        } else {
            ((IInternalEvent)element).getParameterSet(name).addValue(value);
        }
    }
}

