/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.planlib.TestReport;
import jadex.runtime.ICondition;
import jadex.runtime.IGoal;
import jadex.runtime.IInternalEvent;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;

public class LeakerPlan
extends Plan {
    protected int testno = ((Number)this.getParameter("testcase").getValue()).intValue();
    protected int runs = (Integer)this.getBeliefbase().getBelief("runs").getFact();

    public void body() {
        long mem2;
        long time2;
        TestReport tr;
        long mem0;
        long time = System.currentTimeMillis();
        long mem = mem0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.getLogger().info("Starting memory consumption tests.\nUsed memory: " + mem);
        if (this.testno == 0 || this.testno == 1) {
            tr = new TestReport("#1", "Memory consumption of goals.");
            time2 = System.currentTimeMillis();
            this.testGoalCreation(this.runs / 2);
            this.getLogger().info("Time (millis): " + (System.currentTimeMillis() - time2));
            this.waitFor(3L);
            System.gc();
            System.runFinalization();
            mem2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.getLogger().info("Used memory (change): " + (mem2 - mem));
            tr.setSucceeded(true);
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
            mem = mem2;
        }
        if (this.testno == 0 || this.testno == 2) {
            tr = new TestReport("#2", "Memory consumption of conditions.");
            time2 = System.currentTimeMillis();
            this.testConditionCreation(this.runs);
            this.getLogger().info("Time (millis): " + (System.currentTimeMillis() - time2));
            this.waitFor(3L);
            System.gc();
            System.runFinalization();
            mem2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.getLogger().info("Used memory (change): " + (mem2 - mem));
            tr.setSucceeded(true);
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
            mem = mem2;
        }
        if (this.testno == 0 || this.testno == 3) {
            tr = new TestReport("#3", "Memory consumption of internal events.");
            time2 = System.currentTimeMillis();
            this.testInternalEventCreation(this.runs * 3);
            this.getLogger().info("Time (millis): " + (System.currentTimeMillis() - time2));
            this.waitFor(3L);
            System.gc();
            System.runFinalization();
            mem2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.getLogger().info("Used memory (change): " + (mem2 - mem));
            tr.setSucceeded(true);
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
            mem = mem2;
        }
        if (this.testno == 0 || this.testno == 4) {
            tr = new TestReport("#4", "Memory consumption of messages.");
            time2 = System.currentTimeMillis();
            this.testMessageCreationAndSending(this.runs / 10);
            this.getLogger().info("Time (millis): " + (System.currentTimeMillis() - time2));
            this.waitFor(3L);
            System.gc();
            System.runFinalization();
            mem2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.getLogger().info("Used memory (change): " + (mem2 - mem));
            tr.setSucceeded(true);
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
            mem = mem2;
        }
        time = System.currentTimeMillis() - time;
        this.getLogger().info("\nAll tests passed (" + time + " millis).");
        this.getLogger().info("Used memory (total change): " + (mem - mem0));
    }

    protected void testGoalCreation(int num) {
        this.getLogger().info("\n-------- Start of goal creation test --------");
        for (int i = num; i > 0 || num == 0; --i) {
            IGoal goal = this.createGoal("testgoal");
            if (i % 500 != 0) continue;
            this.getLogger().info("" + i);
            this.waitFor(3L);
        }
        this.getLogger().info("\n-------- End of goal creation test --------");
        this.getLogger().info("");
    }

    protected void testConditionCreation(int num) {
        this.getLogger().info("\n-------- Start of condition creation test --------");
        for (int i = num; i > 0 || num == 0; --i) {
            ICondition cond = this.createCondition("false");
            cond.setTraceMode("always");
            if (i % 500 != 0) continue;
            this.getLogger().info("" + i);
            this.waitFor(3L);
        }
        this.getLogger().info("\n-------- End of condition creation test --------");
        this.getLogger().info("");
    }

    protected void testInternalEventCreation(int num) {
        this.getLogger().info("\n-------- Start of internal event creation test --------");
        for (int i = num; i > 0 || num == 0; --i) {
            IInternalEvent event = this.createInternalEvent("testevent");
            if (i % 500 != 0) continue;
            this.getLogger().info("" + i);
            this.waitFor(3L);
        }
        this.getLogger().info("\n-------- End of internal event creation test --------");
        this.getLogger().info("");
    }

    protected void testMessageCreationAndSending(int num) {
        this.getLogger().info("\n-------- Start of message event creation and sending test --------");
        for (int i = num; i > 0 || num == 0; --i) {
            IMessageEvent me = this.createMessageEvent("testmsg");
            this.sendMessage(me);
            if (i % 500 == 0) {
                this.getLogger().info("" + i);
                this.waitFor(3L);
            }
            this.waitFor(0L);
        }
        this.getLogger().info("\n-------- End of message event creation and sending test --------");
        this.getLogger().info("");
    }

    protected long sleeper(long start) {
        if (start + 5000L <= System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            start = System.currentTimeMillis();
        }
        return start;
    }
}

