/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.planlib.TestReport;
import jadex.runtime.IEventbase;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SGUI;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GuiOpenClosePlan
extends Plan {
    protected JFrame frame = new JFrame();
    protected JButton button = new JButton("close_me");

    public GuiOpenClosePlan() {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IEventbase eb = GuiOpenClosePlan.this.getExternalAccess().getEventbase();
                eb.dispatchInternalEvent(eb.createInternalEvent("gui_closed"));
            }
        });
        this.frame.getContentPane().add("Center", this.button);
        this.frame.pack();
        this.frame.setLocation(SGUI.calculateMiddlePosition((Window)this.frame));
        this.frame.setVisible(true);
    }

    public void body() {
        TestReport tr = new TestReport("#1", "Test closing a gui throws gui_event.");
        final Timer t = new Timer(200, null);
        t.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GuiOpenClosePlan.this.button.doClick();
                t.stop();
            }
        });
        t.start();
        this.getLogger().info("Plan is waiting 3 seconds for gui close.");
        try {
            this.waitForInternalEvent("gui_closed", 3000L);
            this.getLogger().info("Gui was closed.");
            tr.setSucceeded(true);
        }
        catch (TimeoutException e) {
            this.getLogger().info("3 secs are over, gui was not closed.");
            tr.setReason("3 secs are over, gui was not closed.");
        }
        this.frame.setVisible(false);
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

