/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IFilter;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import java.util.ArrayList;

public class EndStateWorkerPlan
extends Plan {
    public void body() {
        this.waitFor(IFilter.NEVER);
    }

    public void aborted() {
        ArrayList<TestReport> reports = new ArrayList<TestReport>();
        this.waitFor(20L);
        TestReport report = new TestReport("agenda_action", "Test if goal creation action has not been executed due to invalid precondition.");
        if (this.getGoalbase().getGoals("testgoal").length == 0) {
            report.setSucceeded(true);
        } else {
            report.setFailed("Goal was created.");
        }
        reports.add(report);
        report = new TestReport("agenda_action2", "Test if plan creation action has not been executed due to invalid precondition.");
        if (this.getPlanbase().getPlans("dummy_plan").length == 0) {
            report.setSucceeded(true);
        } else {
            report.setFailed("Plan was created.");
        }
        reports.add(report);
        this.getBeliefbase().getBelief("trigger").setFact((Object)Boolean.FALSE);
        this.getBeliefbase().getBelief("trigger").setFact((Object)Boolean.TRUE);
        this.waitFor(20L);
        report = new TestReport("goal_condition", "Test if goal creation conditions are disabled in end state.");
        if (this.getGoalbase().getGoals("testgoal").length == 0) {
            report.setSucceeded(true);
        } else {
            report.setFailed("Goal was created.");
        }
        reports.add(report);
        report = new TestReport("plan_condition", "Test if plan trigger conditions are disabled in end state.");
        if (this.getPlanbase().getPlans("dummy_plan").length == 0) {
            report.setSucceeded(true);
        } else {
            report.setFailed("Plan was created.");
        }
        reports.add(report);
        report = new TestReport("manual_goal", "Test if manual creation of goal and activation of plan still works.");
        try {
            this.dispatchSubgoalAndWait(this.createGoal("testgoal"), 200L);
            report.setSucceeded(true);
        }
        catch (GoalFailureException e) {
            report.setFailed("Goal execution failed.");
        }
        catch (TimeoutException e) {
            report.setFailed("Timeout occurred.");
        }
        reports.add(report);
        try {
            this.waitForCondition(this.getCondition("end_tests_finished"), 1000L);
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        TestReport[] areports = (TestReport[])this.getBeliefbase().getBeliefSet("reports").getFacts();
        for (int i = 0; i < areports.length; ++i) {
            if (!areports[i].isSucceeded()) {
                areports[i].setFailed("End element was not created");
            }
            reports.add(areports[i]);
        }
        IMessageEvent msg = this.createMessageEvent("inform_reports");
        msg.setContent(reports);
        this.sendMessage(msg);
    }
}

