/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.ServiceDescription;
import jadex.planlib.TestReport;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.util.collection.SCollection;
import java.util.HashMap;
import java.util.List;

public class EndStatePlan
extends Plan {
    public void body() {
        this.getWaitqueue().addMessageEvent("inform_reports");
        IGoal create = this.createGoal("ams_create_agent");
        create.getParameter("type").setValue((Object)"jadex.testcases.misc.EndStateWorker");
        HashMap args = SCollection.createHashMap();
        args.put("testagent", this.getAgentIdentifier());
        create.getParameter("arguments").setValue((Object)args);
        this.dispatchSubgoalAndWait(create);
        AgentIdentifier worker = (AgentIdentifier)create.getParameter("agentidentifier").getValue();
        IMessageEvent msg = this.waitForMessageEvent("inform_reports");
        this.getWaitqueue().removeMessageEvent("inform_reports");
        List reports = (List)msg.getContent();
        this.waitFor(100L);
        IGoal search = this.createGoal("ams_search_agents");
        search.getParameter("description").setValue((Object)new AMSAgentDescription(worker));
        this.dispatchSubgoalAndWait(search);
        TestReport report = new TestReport("termination", "Test if the worker agent has been terminated");
        if (search.getParameterSet("result").getValues().length == 0) {
            report.setSucceeded(true);
        } else {
            report.setFailed("Worker agent still alive.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        for (int i = 0; i < reports.size(); ++i) {
            this.getBeliefbase().getBeliefSet("reports").addFact(reports.get(i));
        }
        report = new TestReport("deregister", "Test if an agent can deregister on termination.");
        create = this.createGoal("ams_create_agent");
        create.getParameter("type").setValue((Object)"jadex.testcases.misc.EndStateDeregister");
        this.dispatchSubgoalAndWait(create);
        AgentIdentifier deregister = (AgentIdentifier)create.getParameter("agentidentifier").getValue();
        this.waitFor(100L);
        AgentDescription desc = new AgentDescription();
        desc.addService(new ServiceDescription(null, "endstate_testservice", null));
        IGoal dfsearch = this.createGoal("df_search");
        dfsearch.getParameter("description").setValue((Object)desc);
        this.dispatchSubgoalAndWait(dfsearch);
        if (dfsearch.getParameterSet("result").getValues().length == 0) {
            report.setFailed("Agent is not registered at DF.");
        } else {
            IGoal destroy = this.createGoal("ams_destroy_agent");
            destroy.getParameter("agentidentifier").setValue((Object)deregister);
            this.dispatchSubgoalAndWait(destroy);
            this.waitFor(100L);
            dfsearch = this.createGoal("df_search");
            dfsearch.getParameter("description").setValue((Object)desc);
            this.dispatchSubgoalAndWait(dfsearch);
            if (dfsearch.getParameterSet("result").getValues().length != 0) {
                report.setFailed("Agent is still registered at DF.");
            } else {
                search = this.createGoal("ams_search_agents");
                search.getParameter("description").setValue((Object)new AMSAgentDescription(deregister));
                this.dispatchSubgoalAndWait(search);
                if (search.getParameterSet("result").getValues().length != 0) {
                    report.setFailed("Deregister agent still alive.");
                } else {
                    report.setSucceeded(true);
                }
            }
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
    }
}

