/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.model.IMAchieveGoal;
import jadex.model.IMAchieveGoalReference;
import jadex.model.IMBelief;
import jadex.model.IMCapability;
import jadex.model.IMEventReference;
import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.model.IMInternalEventReference;
import jadex.model.IMPlan;
import jadex.model.IMPlanTrigger;
import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.IInternalEvent;
import jadex.runtime.Plan;

public class DynamicModelCreationPlan
extends Plan {
    public void body() {
        IMCapability mcapa = (IMCapability)this.getScope().getModelElement();
        this.getLogger().info("----------------------------------");
        TestReport tr = new TestReport("#1", "Create a new belief, goal and plan model in the agent and test if the plan triggers.");
        this.getLogger().info("Testcase 1: Create a new belief, goal and plan model in the agent and test if the plan triggers.");
        IMBelief mbel = mcapa.getBeliefbase().createBelief("new_belief_model", Integer.TYPE, 0L, "false");
        this.getBeliefbase().registerBelief(mbel);
        this.getLogger().info("Created belief model at runtime: " + mbel + " " + this.getBeliefbase().getBelief("new_belief_model"));
        IMAchieveGoal mgoal = mcapa.getGoalbase().createAchieveGoal("new_goal_model", "false", true, 0L, "when_failed");
        mgoal.createParameter("test_no", Integer.class, "inout", 0L, "1", "static");
        mgoal.createCreationCondition("$beliefbase.new_belief_model>0");
        this.getGoalbase().registerGoal((IMGoal)mgoal);
        this.getLogger().info("Created goal model at runtime: " + mgoal);
        IMPlan mplan = mcapa.getPlanbase().createPlan("new_plan_model", 0, "new jadex.testcases.ResultPlan($plan.pp)", "standard");
        IMPlanTrigger mtrig = mplan.createTrigger();
        mtrig.createGoal("new_goal_model");
        mplan.createPlanParameter("pp", Integer.class, "inout", 0L, null, null, null, null, new String[]{"new_goal_model.test_no"});
        this.getPlanbase().registerPlan(mplan);
        this.getLogger().info("Created plan model at runtime: " + mplan);
        this.getBeliefbase().getBelief("new_belief_model").setFact((Object)new Integer(1));
        IGoal goal = this.createGoal("new_goal_model");
        goal.getParameter("test_no").setValue((Object)new Integer(2));
        try {
            this.dispatchSubgoalAndWait(goal);
            this.getLogger().info("Test succeeded: subgoal succeeded!");
            tr.setSucceeded(true);
        }
        catch (GoalFailureException e) {
            this.getLogger().info("Test failed: subgoal failed.");
            tr.setReason("Subgoal failed: " + (Object)((Object)e));
        }
        this.getLogger().info("----------------------------------");
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#2", "Remove the plan and test if it still triggers.");
        this.getLogger().info("Testcase 2: Remove the plan and test if it still triggers.");
        this.getGoalbase().deregisterGoal((IMGoal)mgoal);
        this.getPlanbase().deregisterPlan(mplan);
        this.getBeliefbase().getBelief("new_belief_model").setFact((Object)new Integer(2));
        this.getBeliefbase().deregisterBelief(mbel);
        mcapa.getGoalbase().deleteAchieveGoal(mgoal);
        mcapa.getPlanbase().deletePlan(mplan);
        mcapa.getBeliefbase().deleteBelief(mbel);
        try {
            goal = this.createGoal("new_goal_model");
            goal.getParameter("test_no").setValue((Object)new Integer(2));
            this.dispatchSubgoalAndWait(goal);
            this.getLogger().info("Test failed: subgoal failed.");
            tr.setReason("Subgoal failed.");
        }
        catch (Exception e) {
            this.getLogger().info("Test succeeded.");
            tr.setSucceeded(true);
        }
        this.getLogger().info("----------------------------------");
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#3", "Create a goal reference and dispatch a goal that is handled in another capability.");
        this.getLogger().info("Testcase 3: Create a goal reference and dispatch a goal that is handled in another capability.");
        IMAchieveGoalReference mgoalref = mcapa.getGoalbase().createAchieveGoalReference("new_goal_ref", "false", "dyncapa.capagoal");
        mgoalref.createParameterReference("param", String.class);
        this.getGoalbase().registerGoalReference((IMGoalReference)mgoalref);
        this.getLogger().info("Created goal reference model at runtime: " + mgoalref);
        goal = this.createGoal("new_goal_ref");
        goal.getParameter("param").setValue((Object)"The goal ref value.");
        try {
            this.dispatchSubgoalAndWait(goal);
            this.getLogger().info("Test succeeded: subgoal succeeded!");
            tr.setSucceeded(true);
        }
        catch (GoalFailureException e) {
            this.getLogger().info("Test failed: subgoal failed.");
            tr.setReason("Subgoal failed: " + (Object)((Object)e));
        }
        this.getLogger().info("----------------------------------");
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#4", "Create an event reference and dispatch an event that is handled in another capability.");
        this.getLogger().info("Testcase 4: Create an event reference and dispatch an event that is handled in another capability.");
        IMInternalEventReference meventref = mcapa.getEventbase().createInternalEventReference("new_event_ref", "false", "dyncapa.capaevent", false);
        try {
            meventref.createParameterReference("param", String.class);
            this.getEventbase().registerEventReference((IMEventReference)meventref);
            this.getLogger().info("Created event reference model at runtime: " + meventref);
            IInternalEvent event = this.createInternalEvent("new_event_ref");
            event.getParameter("param").setValue((Object)"The event ref value.");
            this.dispatchInternalEvent(event);
            tr.setSucceeded(true);
        }
        catch (Exception e) {
            tr.setReason("Exception occurred: " + e);
        }
        this.getLogger().info("----------------------------------");
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#5", " Deregister and remove everything created.");
        this.getLogger().info("Testcase 5: Deregister and remove everything created.");
        try {
            this.getGoalbase().deregisterGoalReference((IMGoalReference)mgoalref);
            mcapa.getGoalbase().deleteAchieveGoalReference(mgoalref);
            this.getEventbase().deregisterEventReference((IMEventReference)meventref);
            mcapa.getEventbase().deleteInternalEventReference(meventref);
            tr.setSucceeded(true);
        }
        catch (Exception e) {
            tr.setReason("Exception occurred: " + e);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

