/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.SFipa;
import jadex.planlib.TestReport;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SUtil;
import java.util.Date;

public class DFTestPlan
extends Plan {
    public void body() {
        int num = 1;
        num = this.performInitialTests(num);
        num = this.performTests(num, null);
        this.performTests(num, (BasicAgentIdentifier)SFipa.DF);
    }

    public int performInitialTests(int num) {
        AgentDescription desc = (AgentDescription)this.getScope().getPropertybase().getProperty("fipa.agentdescription.dftest");
        TestReport tr = new TestReport("#" + num++, "Try to search for initial registration.");
        this.getLogger().info("\nTrying to search...");
        IGoal search = this.createGoal("df_search");
        search.getParameter("description").setValue((Object)desc);
        try {
            this.dispatchSubgoalAndWait(search);
            this.getLogger().info(" search ok: " + SUtil.arrayToString((Object)search.getParameterSet("result").getValues()));
            tr.setSucceeded(true);
        }
        catch (GoalFailureException gfe) {
            this.getLogger().info(" search failed. " + search.getParameterSet("result").getValues());
            tr.setReason("Search failed. " + search.getParameterSet("result").getValues());
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Trying to keep registered...");
        tr = new TestReport("#" + num++, "Try to keep (modify) initial registration.");
        try {
            IGoal keep = this.waitForGoal("df_keep_registered", 6000L);
            if (keep.isSucceeded()) {
                this.getLogger().info(" modify succeeded. ");
            }
            tr.setSucceeded(true);
            keep.drop();
        }
        catch (TimeoutException e) {
            this.getLogger().info(" modify failed.");
            tr.setReason("Modify failed.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        IGoal deregister = this.createGoal("df_deregister");
        deregister.getParameter("description").setValue((Object)desc);
        try {
            this.dispatchSubgoalAndWait(deregister);
        }
        catch (GoalFailureException gfe) {
            // empty catch block
        }
        return num;
    }

    public int performTests(int num, BasicAgentIdentifier df) {
        IGoal search;
        AgentDescription desc = (AgentDescription)this.getScope().getPropertybase().getProperty("fipa.agentdescription.dftest");
        AgentDescription desc_clone = (AgentDescription)desc.clone();
        long olt = System.currentTimeMillis() + 2000L;
        desc_clone.setLeaseTime(new Date(olt));
        TestReport tr = new TestReport("#" + num++, "Test of lease time.");
        this.getLogger().info("Testing lease time...");
        IGoal register = this.createGoal("df_register");
        register.getParameter("description").setValue((Object)desc_clone);
        register.getParameter("df").setValue((Object)df);
        try {
            this.dispatchSubgoalAndWait(register);
            this.getLogger().info(" register ok.");
            this.waitFor(2200L);
            search = this.createGoal("df_search");
            search.getParameter("description").setValue((Object)desc_clone);
            search.getParameter("df").setValue((Object)df);
            this.dispatchSubgoalAndWait(search);
            if (search.getParameterSet("result").getValues().length > 0) {
                this.getLogger().info(" lease time test failed. " + search.getParameterSet("result").getValues());
                tr.setReason("Lease time test failed. " + search.getParameterSet("result").getValues());
            } else {
                tr.setSucceeded(true);
            }
        }
        catch (GoalFailureException gfe) {
            this.getLogger().info(" register failed. " + register.getParameter("result").getValue());
            tr.setReason("Register failed. " + register.getParameter("result").getValue());
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#" + num++, "Try to register.");
        this.getLogger().info("Trying to register...");
        register = this.createGoal("df_register");
        register.getParameter("description").setValue((Object)desc);
        register.getParameter("df").setValue((Object)df);
        try {
            this.dispatchSubgoalAndWait(register);
            this.getLogger().info(" register ok.");
            tr.setSucceeded(true);
        }
        catch (GoalFailureException gfe) {
            this.getLogger().info(" register failed. " + register.getParameter("result").getValue());
            tr.setReason("Register failed. " + register.getParameter("result").getValue());
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#" + num++, "Try to search.");
        this.getLogger().info("\nTrying to search...");
        search = this.createGoal("df_search");
        search.getParameter("description").setValue((Object)desc);
        search.getParameter("df").setValue((Object)df);
        try {
            this.dispatchSubgoalAndWait(search);
            this.getLogger().info(" search ok: " + SUtil.arrayToString((Object)search.getParameterSet("result").getValues()));
            tr.setSucceeded(true);
        }
        catch (GoalFailureException gfe) {
            this.getLogger().info(" search failed. " + search.getParameterSet("result").getValues());
            tr.setReason("Search failed. " + search.getParameterSet("result").getValues());
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#" + num++, "Try to deregister.");
        this.getLogger().info("\nTrying to deregister...");
        IGoal deregister = this.createGoal("df_deregister");
        deregister.getParameter("description").setValue((Object)desc);
        deregister.getParameter("df").setValue((Object)df);
        try {
            this.dispatchSubgoalAndWait(deregister);
            this.getLogger().info(" deregister ok.");
            tr.setSucceeded(true);
        }
        catch (GoalFailureException gfe) {
            this.getLogger().info(" deregister failed. " + deregister);
            tr.setReason("Deregister failed: " + deregister);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#" + num++, "Try to keep registered (initial register).");
        this.getLogger().info("Trying to keep registered (should modify each 5 sec)...");
        IGoal keep = this.createGoal("df_keep_registered");
        keep.getParameter("description").setValue((Object)desc);
        keep.getParameter("leasetime").setValue((Object)new Integer(5000));
        keep.getParameter("df").setValue((Object)df);
        Object event = null;
        try {
            this.dispatchSubgoalAndWait(keep);
        }
        catch (GoalFailureException e) {
            e.printStackTrace();
            this.getLogger().warning("Exception: " + (Object)((Object)e));
        }
        if (keep.isSucceeded()) {
            this.getLogger().info(" initial register ok.");
            tr.setSucceeded(true);
        } else {
            this.getLogger().info(" initial register failed: " + keep.getLifecycleState() + ", " + event);
            tr.setReason("Initial register failed: " + keep.getLifecycleState() + ", " + event);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("Trying to keep registered...");
        tr = new TestReport("#" + num++, "Try to keep registered (modify).");
        try {
            this.waitForSubgoal(keep, 6000L);
            if (keep.isSucceeded()) {
                this.getLogger().info(" modify succeeded. ");
            }
            tr.setSucceeded(true);
        }
        catch (TimeoutException e) {
            this.getLogger().info(" modify failed. " + keep);
            tr.setReason("Modify failed. " + keep);
        }
        keep.drop();
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        try {
            IGoal deregister2 = this.createGoal("df_deregister");
            deregister2.getParameter("description").setValue((Object)desc);
            deregister2.getParameter("df").setValue((Object)df);
            this.dispatchSubgoalAndWait(deregister2);
        }
        catch (GoalFailureException e) {
            // empty catch block
        }
        return num;
    }
}

