/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.planlib.TestReport;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IBeliefListener;
import jadex.runtime.IBeliefSetListener;
import jadex.runtime.ICondition;
import jadex.runtime.IConditionListener;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.runtime.IInternalEvent;
import jadex.runtime.IInternalEventListener;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IMessageEventListener;
import jadex.runtime.IPlanListener;
import jadex.runtime.Plan;
import jadex.runtime.impl.RCapability;

public class CallbackPlan
extends Plan {
    public void body() {
        TestReport tr15 = new TestReport("#15", "Test if all listeners will also be removed");
        int start = ((RCapability)this.getCapability().unwrap()).getAgent().getSystemEventListeners().length;
        final TestReport tr1 = new TestReport("#1", "Test if belief changes can be observed in a listener.");
        this.getBeliefbase().getBelief("bel").addBeliefListener(new IBeliefListener(){

            public void beliefChanged(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("belief changed: " + ae);
                CallbackPlan.this.getExternalAccess().getBeliefbase().getBelief("bel").removeBeliefListener((IBeliefListener)this);
                tr1.setSucceeded(true);
            }
        }, false);
        this.getBeliefbase().getBelief("bel").setFact((Object)new Integer(1));
        this.waitFor(200L);
        if (!tr1.isSucceeded()) {
            tr1.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr1);
        final TestReport tr2 = new TestReport("#2", "Test if belief set added can be observed in a listener.");
        this.getBeliefbase().getBeliefSet("belset").addBeliefSetListener(new IBeliefSetListener(){

            public void factAdded(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("fact added: " + ae);
                CallbackPlan.this.getExternalAccess().getBeliefbase().getBeliefSet("belset").removeBeliefSetListener((IBeliefSetListener)this);
                tr2.setSucceeded(true);
            }

            public void factRemoved(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("fact removed: " + ae);
            }

            public void beliefSetChanged(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("belief set changed: " + ae);
            }
        }, false);
        this.getBeliefbase().getBeliefSet("belset").addFact((Object)new Integer(1));
        this.waitFor(200L);
        if (!tr2.isSucceeded()) {
            tr2.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr2);
        final TestReport tr2b = new TestReport("#2b", "Test if belief set removed can be observed in a listener.");
        this.getBeliefbase().getBeliefSet("belset").addBeliefSetListener(new IBeliefSetListener(){

            public void factAdded(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("fact added: " + ae);
            }

            public void factRemoved(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("fact removed: " + ae);
                CallbackPlan.this.getExternalAccess().getBeliefbase().getBeliefSet("belset").removeBeliefSetListener((IBeliefSetListener)this);
                tr2b.setSucceeded(true);
            }

            public void beliefSetChanged(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("belief set changed: " + ae);
            }
        }, false);
        this.getBeliefbase().getBeliefSet("belset").removeFact((Object)new Integer(1));
        this.waitFor(200L);
        if (!tr2b.isSucceeded()) {
            tr2b.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr2b);
        final TestReport tr3 = new TestReport("#3", "Test if goal finished can be observed in a listener.");
        IGoal goal = this.createGoal("goal");
        IGoalListener gl = new IGoalListener(){

            public void goalAdded(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Goal added called");
            }

            public void goalFinished(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Goal finished called");
                tr3.setSucceeded(true);
            }
        };
        goal.addGoalListener(gl, false);
        try {
            this.dispatchSubgoalAndWait(goal);
        }
        catch (GoalFailureException e) {
            // empty catch block
        }
        if (!tr3.isSucceeded()) {
            tr3.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr3);
        goal.removeGoalListener(gl);
        final TestReport tr4 = new TestReport("#4", "Test if goal added can be observed in a listener.");
        final TestReport tr5 = new TestReport("#5", "Test if goal finished can be observed in a listener.");
        final TestReport tr5b = new TestReport("#5b", "Test if waitFor can be called in async listener.");
        this.getGoalbase().addGoalListener("goal", new IGoalListener(){

            public void goalAdded(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Goal added called");
                tr4.setSucceeded(true);
            }

            public void goalFinished(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Goal finished called");
                CallbackPlan.this.getExternalAccess().getGoalbase().removeGoalListener("goal", (IGoalListener)this);
                tr5.setSucceeded(true);
                try {
                    CallbackPlan.this.getExternalAccess().waitFor(100L);
                    tr5b.setSucceeded(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, true);
        this.getBeliefbase().getBelief("bel").setFact((Object)new Integer(2));
        this.waitFor(200L);
        if (!tr4.isSucceeded()) {
            tr4.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr4);
        if (!tr5.isSucceeded()) {
            tr5.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr5);
        if (!tr5b.isSucceeded()) {
            tr5b.setReason("Could not call waitFor() in listener");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr5b);
        final TestReport tr6 = new TestReport("#6", "Test if internal event occurred can be observed in a listener.");
        this.getEventbase().addInternalEventListener("internal_event", new IInternalEventListener(){

            public void internalEventOccurred(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Internal event occurred called");
                CallbackPlan.this.getExternalAccess().getEventbase().removeInternalEventListener("internal_event", (IInternalEventListener)this);
                tr6.setSucceeded(true);
            }
        }, false);
        IInternalEvent ievent = this.createInternalEvent("internal_event");
        this.dispatchInternalEvent(ievent);
        this.waitFor(200L);
        if (!tr6.isSucceeded()) {
            tr6.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr6);
        final TestReport tr7 = new TestReport("#7", "Test if message event sent can be observed in a listener.");
        final TestReport tr8 = new TestReport("#8", "Test if message event reply can be observed in a listener.");
        final TestReport tr9 = new TestReport("#9", "Test if message event sent can be observed in a listener.");
        IMessageEvent mevent = this.createMessageEvent("message_event");
        mevent.getParameterSet("receivers").addValue((Object)this.getAgentIdentifier());
        mevent.getParameter("sender").setValue((Object)this.getAgentIdentifier());
        IMessageEventListener mel = new IMessageEventListener(){

            public void messageEventReceived(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Message event received");
                tr7.setSucceeded(true);
            }

            public void messageEventSent(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Message event sent");
                tr8.setSucceeded(true);
            }
        };
        this.getEventbase().addMessageEventListener("message_event", new IMessageEventListener(){

            public void messageEventReceived(AgentEvent ae) {
            }

            public void messageEventSent(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Message event sent");
                CallbackPlan.this.getExternalAccess().getEventbase().removeMessageEventListener("message_event", (IMessageEventListener)this);
                tr9.setSucceeded(true);
            }
        }, false);
        mevent.addMessageEventListener(mel, false);
        this.sendMessage(mevent);
        this.waitFor(200L);
        if (!tr7.isSucceeded()) {
            tr7.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr7);
        if (!tr9.isSucceeded()) {
            tr9.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr9);
        IMessageEvent rep = mevent.createReply("message_event");
        this.sendMessage(rep);
        this.waitFor(200L);
        if (!tr8.isSucceeded()) {
            tr8.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr8);
        mevent.removeMessageEventListener(mel);
        final TestReport tr10 = new TestReport("#10", "Test if condition triggered can be observed in a listener.");
        ICondition cond = this.createCondition("$beliefbase.bel==3");
        IConditionListener cl = new IConditionListener(){

            public void conditionTriggered(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Condition triggered");
                tr10.setSucceeded(true);
            }
        };
        cond.addConditionListener(cl, false);
        cond.traceOnce();
        this.getBeliefbase().getBelief("bel").setFact((Object)new Integer(3));
        this.waitFor(200L);
        if (!tr10.isSucceeded()) {
            tr10.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr10);
        cond.removeConditionListener(cl);
        final TestReport tr11 = new TestReport("#11", "Test if adf condition triggered can be observed in a listener.");
        this.getExpressionbase().addConditionListener("condition", new IConditionListener(){

            public void conditionTriggered(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Condition triggered");
                CallbackPlan.this.getExternalAccess().getExpressionbase().removeConditionListener("condition", (IConditionListener)this);
                tr11.setSucceeded(true);
            }
        }, false);
        cond = this.getCondition("condition");
        cond.traceOnce();
        this.getBeliefbase().getBelief("bel").setFact((Object)new Integer(5));
        this.waitFor(200L);
        if (!tr11.isSucceeded()) {
            tr11.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr11);
        final TestReport tr12 = new TestReport("#12", "Test if plan added can be observed in a listener.");
        final TestReport tr13 = new TestReport("#13", "Test if plan removed can be observed in a listener.");
        IPlanListener pl = new IPlanListener(){

            public void planAdded(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Plan added");
                tr12.setSucceeded(true);
            }

            public void planFinished(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Plan removed");
                tr13.setSucceeded(true);
            }
        };
        this.getPlanbase().addPlanListener("plan", pl, false);
        this.getBeliefbase().getBelief("bel").setFact((Object)new Integer(4));
        this.waitFor(200L);
        if (!tr12.isSucceeded()) {
            tr12.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr12);
        if (!tr13.isSucceeded()) {
            tr13.setReason("Listener was not notified.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr13);
        this.getPlanbase().removePlanListener("plan", pl);
        int end = ((RCapability)this.getCapability().unwrap()).getAgent().getSystemEventListeners().length;
        if (start == end) {
            tr15.setSucceeded(true);
        } else {
            tr15.setReason("The listener count is different: " + start + " vs. " + end);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr15);
        final TestReport tr14 = new TestReport("#14", "Test if plan removed (on this plan) can be observed in a listener.");
        this.addPlanListener(new IPlanListener(){

            public void planAdded(AgentEvent ae) {
            }

            public void planFinished(AgentEvent ae) {
                CallbackPlan.this.getExternalAccess().getLogger().info("Plan removed");
                tr14.setSucceeded(true);
                CallbackPlan.this.getExternalAccess().getBeliefbase().getBeliefSet("reports").addFact((Object)tr14);
                CallbackPlan.this.removePlanListener(this);
            }
        }, false);
        this.getScope().addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                System.out.println("Agent terminating invoked");
                CallbackPlan.this.getScope().removeAgentListener((IAgentListener)this);
            }
        }, false);
    }
}

