/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.collection.SCollection;
import java.util.HashMap;

public class ArgumentsPlan
extends Plan {
    public void body() {
        TestReport tr = new TestReport("#1", "Test if a worker agent can be started and supplied with arguments.");
        try {
            IGoal ca = this.createGoal("ams_create_agent");
            ca.getParameter("type").setValue((Object)"jadex.testcases.misc.ArgumentsWorker");
            HashMap args = SCollection.createHashMap();
            args.put("creator", this.getAgentIdentifier());
            ca.getParameter("arguments").setValue((Object)args);
            this.dispatchSubgoalAndWait(ca);
            AgentIdentifier worker = (AgentIdentifier)ca.getParameter("agentidentifier").getValue();
            this.waitForMessageEvent("inform_created", 1000L);
            tr.setSucceeded(true);
        }
        catch (GoalFailureException e) {
            tr.setReason("Could not create worker agent.");
            this.getLogger().severe("Exception while creating the worker agent: " + (Object)((Object)e));
        }
        catch (TimeoutException e) {
            tr.setReason("Worker did not send message.");
            this.getLogger().severe("Timeout while waiting for message receival: " + (Object)((Object)e));
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

