/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.misc;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SFipa;
import jadex.adapter.fipa.SearchConstraints;
import jadex.planlib.TestReport;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;

public class AMSTestPlan
extends Plan {
    public void body() {
        int num = 1;
        num = this.performTests(num, null);
        this.performTests(num, (BasicAgentIdentifier)SFipa.AMS);
    }

    public void failed() {
        System.err.println("\nSome tests failed!");
    }

    public int performTests(int num, BasicAgentIdentifier ams) {
        TestReport tr;
        block22: {
            IGoal create;
            IGoal search;
            SearchConstraints constraints;
            AMSAgentDescription desc;
            block21: {
                tr = new TestReport("#" + num++, "Searching for all agents");
                this.getLogger().info("\nSearching for all agents.");
                desc = new AMSAgentDescription();
                constraints = new SearchConstraints();
                constraints.setMaxResults(-1);
                search = this.createGoal("ams_search_agents");
                search.getParameter("description").setValue((Object)desc);
                search.getParameter("constraints").setValue((Object)constraints);
                search.getParameter("ams").setValue((Object)ams);
                try {
                    this.dispatchSubgoalAndWait(search);
                    AMSAgentDescription[] result = (AMSAgentDescription[])search.getParameterSet("result").getValues();
                    this.getLogger().info("Success! Found agents: " + result.length);
                    for (int i = 0; i < result.length; ++i) {
                        this.getLogger().info("Agent " + i + ": " + result[i].getName());
                    }
                    tr.setSucceeded(true);
                }
                catch (GoalFailureException e) {
                    tr.setReason("Search subgoal failed.");
                }
                this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
                tr = new TestReport("#" + num++, "Trying to create ping agent.");
                this.getLogger().info("\nTrying to create ping agent.");
                create = this.createGoal("ams_create_agent");
                create.getParameter("type").setValue((Object)"jadex.examples.ping.Ping");
                create.getParameter("ams").setValue((Object)ams);
                try {
                    this.dispatchSubgoalAndWait(create);
                    this.getLogger().info("Success: Created " + create.getParameter("agentidentifier").getValue());
                    tr.setSucceeded(true);
                }
                catch (GoalFailureException e) {
                    e.printStackTrace();
                    tr.setReason("Create agent subgoal failed.");
                }
                this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
                tr = new TestReport("#" + num++, "Searching for ping agent.");
                if (create.isSucceeded()) {
                    this.getLogger().info("\nSearching for ping agent.");
                    desc = new AMSAgentDescription();
                    desc.setName((AgentIdentifier)create.getParameter("agentidentifier").getValue());
                    constraints = new SearchConstraints();
                    constraints.setMaxResults(-1);
                    search = this.createGoal("ams_search_agents");
                    search.getParameter("description").setValue((Object)desc);
                    search.getParameter("constraints").setValue((Object)constraints);
                    search.getParameter("ams").setValue((Object)ams);
                    try {
                        this.dispatchSubgoalAndWait(search);
                        AMSAgentDescription[] result = (AMSAgentDescription[])search.getParameterSet("result").getValues();
                        if (result.length == 1) {
                            this.getLogger().info("Success! Found ping agent:" + result[0].getName());
                            tr.setSucceeded(true);
                            break block21;
                        }
                        System.err.println("Failure! Found " + result.length + " agents.");
                        for (int i = 0; i < result.length; ++i) {
                            System.err.println("Agent " + i + ": " + result[i].getName());
                        }
                        tr.setReason("Could not find ping agent.");
                    }
                    catch (GoalFailureException e) {
                        tr.setReason("Search subgoal failed.");
                    }
                } else {
                    tr.setReason("Cannot search because creation already failed.");
                }
            }
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
            tr = new TestReport("#" + num++, "Trying to destroy ping agent.");
            if (create.isSucceeded()) {
                this.getLogger().info("\nTrying to destroy ping agent.");
                IGoal destroy = this.createGoal("ams_destroy_agent");
                destroy.getParameter("agentidentifier").setValue(create.getParameter("agentidentifier").getValue());
                destroy.getParameter("ams").setValue((Object)ams);
                try {
                    this.dispatchSubgoalAndWait(destroy);
                    this.getLogger().info("Success: Ping agent was destroyed.");
                    tr.setSucceeded(true);
                }
                catch (GoalFailureException e) {
                    tr.setReason("Destroy subgoal failed.");
                }
            } else {
                tr.setReason("Cannot destroy because creation already failed.");
            }
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
            tr = new TestReport("#" + num++, "Searching for ping agent again.");
            if (create.isSucceeded()) {
                this.getLogger().info("\nSearching for ping agent again.");
                desc = new AMSAgentDescription();
                desc.setName((AgentIdentifier)create.getParameter("agentidentifier").getValue());
                constraints = new SearchConstraints();
                constraints.setMaxResults(-1);
                search = this.createGoal("ams_search_agents");
                search.getParameter("description").setValue((Object)desc);
                search.getParameter("constraints").setValue((Object)constraints);
                search.getParameter("ams").setValue((Object)ams);
                try {
                    this.dispatchSubgoalAndWait(search);
                    AMSAgentDescription[] result = (AMSAgentDescription[])search.getParameterSet("result").getValues();
                    if (result.length == 0) {
                        this.getLogger().info("Success! Found 0 agents.");
                        tr.setSucceeded(true);
                        break block22;
                    }
                    System.err.println("Failure! Found " + result.length + " agents.");
                    for (int i = 0; i < result.length; ++i) {
                        System.err.println("Agent " + i + ": " + result[i].getName());
                    }
                    tr.setReason("Found an agent that should not be there.");
                }
                catch (GoalFailureException e) {
                    tr.setReason("Search subgoal failed.");
                }
            } else {
                tr.setReason("Cannot search because creation already failed.");
            }
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        return num;
    }
}

