/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.goals;

import jadex.planlib.TestReport;
import jadex.runtime.IEvent;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalEvent;
import jadex.runtime.MobilePlan;
import jadex.runtime.TimeoutException;

public class SubgoalTimeoutMobilePlan
extends MobilePlan {
    protected TestReport report = new TestReport("test_timeout", "Test if a subgoal times out.");

    public void action(IEvent event) {
        if (event instanceof IGoalEvent) {
            if (((IGoalEvent)event).getGoal().isFailed()) {
                this.report.setReason("Should not call action with failed subgoal.");
            } else {
                this.report.setReason("Subgoal unexpectedly succeeded.");
            }
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)this.report);
        } else {
            IGoal sg = this.createGoal("timeout_goal");
            this.dispatchSubgoalAndWait(sg, 100L);
        }
    }

    public void exception(Exception exception) throws Exception {
        if (exception instanceof TimeoutException) {
            this.report.setSucceeded(true);
        } else {
            this.report.setReason("Wrong exception: " + exception);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)this.report);
    }
}

