/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.goals;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;

public class SubgoalHandlingPlan
extends Plan {
    public void body() {
        TestReport report = new TestReport("test_success", "Test if a subgoal succeeds.");
        IGoal sg = this.createGoal("success_goal");
        try {
            this.dispatchSubgoalAndWait(sg);
            if (sg.isSucceeded()) {
                report.setSucceeded(true);
            } else {
                report.setReason("Should not continue execution after failed subgoal.");
            }
        }
        catch (Exception e) {
            report.setReason("Unexpected exception: " + e);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("test_failure", "Test if a subgoal fails.");
        sg = this.createGoal("failure_goal");
        try {
            this.dispatchSubgoalAndWait(sg);
            if (sg.isSucceeded()) {
                report.setReason("Subgoal unexpectedly succeeded.");
            } else {
                report.setReason("Should not continue execution after failed subgoal.");
            }
        }
        catch (Exception e) {
            if (e instanceof GoalFailureException) {
                report.setSucceeded(true);
            }
            report.setReason("Wrong exception: " + e);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("test_failure", "Test if a subgoal times out.");
        sg = this.createGoal("timeout_goal");
        try {
            this.dispatchSubgoalAndWait(sg, 100L);
            if (sg.isSucceeded()) {
                report.setReason("Subgoal unexpectedly succeeded.");
            } else {
                report.setReason("Should not continue execution after failed subgoal.");
            }
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                report.setSucceeded(true);
            }
            report.setReason("Wrong exception: " + e);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
    }
}

