/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.goals;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IEvent;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalEvent;
import jadex.runtime.MobilePlan;

public class SubgoalFailureMobilePlan
extends MobilePlan {
    protected TestReport report = new TestReport("test_failure", "Test if a subgoal fails.");

    public void action(IEvent event) {
        if (event instanceof IGoalEvent) {
            if (((IGoalEvent)event).getGoal().isFailed()) {
                this.report.setReason("Should not call action with failed subgoal.");
            } else {
                this.report.setReason("Subgoal unexpectedly succeeded.");
            }
            this.getBeliefbase().getBeliefSet("reports").addFact((Object)this.report);
        } else {
            IGoal sg = this.createGoal("failure_goal");
            this.dispatchSubgoalAndWait(sg);
        }
    }

    public void exception(Exception exception) throws Exception {
        if (exception instanceof GoalFailureException) {
            this.report.setSucceeded(true);
        } else {
            this.report.setReason("Wrong exception: " + exception);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)this.report);
    }
}

