/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.goals;

import jadex.planlib.TestReport;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;

public class MaintainTestPlan
extends Plan {
    public void body() {
        TestReport report = new TestReport("dispatch_maintain", "Dispatch a maintain goal that should start processing.");
        this.getLogger().info("Creating goal");
        IGoal maintain = this.createGoal("maintain");
        this.dispatchSubgoal(maintain);
        this.waitFor(100L);
        if (((Number)this.getBeliefbase().getBelief("count").getFact()).intValue() >= 5 || ((Number)this.getBeliefbase().getBelief("count").getFact()).intValue() <= 0) {
            report.setReason("Belief should be 0<count<5, but was: " + this.getBeliefbase().getBelief("count").getFact());
        } else {
            report.setSucceeded(true);
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("suspend_maintain", "Suspend the maintain goal by invalidating the context.");
        this.getLogger().info("Suspending goal: " + maintain);
        this.getBeliefbase().getBelief("context").setFact((Object)Boolean.FALSE);
        this.waitFor(100L);
        if ("suspended".equals(maintain.getLifecycleState())) {
            report.setSucceeded(true);
        } else {
            report.setReason("Goal should be suspended, but was: " + maintain.getLifecycleState());
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("reactivate_maintain", "Reactivate the maintain goal by validating the context.");
        this.getLogger().info("Reactivating goal: " + maintain);
        this.getBeliefbase().getBelief("context").setFact((Object)Boolean.TRUE);
        this.waitFor(100L);
        if ("active".equals(maintain.getLifecycleState())) {
            report.setSucceeded(true);
        } else {
            report.setReason("Goal should be active, but was: " + maintain.getLifecycleState());
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
        report = new TestReport("waitfor_maintain", "Wait for the maintain goal to finish.");
        this.getLogger().info("Waiting for goal to finish (500 millis).");
        try {
            this.waitForSubgoal(maintain, 500L);
            report.setSucceeded(true);
        }
        catch (TimeoutException e) {
            report.setReason("Goal did not finish.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
    }
}

