/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.events;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.IterationDecider;
import jadex.planlib.Selector;
import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.testcases.AbstractMultipleAgentsPlan;
import jadex.util.SUtil;
import java.util.List;
import java.util.Map;

public class ProtocolTestPlan
extends AbstractMultipleAgentsPlan {
    public void body() {
        IGoal cnpini;
        Map[] args = new Map[2];
        List agents = this.createAgents("jadex.testcases.events.ProtocolReceiver", args);
        TestReport tr = new TestReport("#1", "Test request protocol.");
        if (this.assureTest(tr)) {
            try {
                IGoal request = this.createGoal("rp_initiate");
                request.getParameter("content").setValue((Object)"Request a task.");
                request.getParameter("receiver").setValue(agents.get(0));
                this.dispatchSubgoalAndWait(request);
                this.getLogger().info("Request result:" + request.getParameter("result").getValue());
                tr.setSucceeded(true);
            }
            catch (GoalFailureException e) {
                tr.setFailed("Exception occurred: " + (Object)((Object)e));
            }
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#2", "Test cnp protocol.");
        if (this.assureTest(tr)) {
            try {
                cnpini = this.createGoal("cnp_initiate");
                cnpini.getParameterSet("receivers").addValues((Object[])agents.toArray(new AgentIdentifier[agents.size()]));
                cnpini.getParameter("content").setValue((Object)"CFP for a task.");
                cnpini.getParameter("selector").setValue((Object)new Selector(-1));
                this.dispatchSubgoalAndWait(cnpini);
                this.getLogger().info("CFP result:" + SUtil.arrayToString((Object)cnpini.getParameterSet("result").getValues()));
                tr.setSucceeded(true);
            }
            catch (GoalFailureException e) {
                tr.setFailed("Exception occurred: " + (Object)((Object)e));
            }
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#3", "Test iterated-cnp protocol.");
        if (this.assureTest(tr)) {
            try {
                cnpini = this.createGoal("cnp_initiate");
                cnpini.getParameterSet("receivers").addValues((Object[])agents.toArray(new AgentIdentifier[agents.size()]));
                cnpini.getParameter("content").setValue((Object)"CFP for a task.");
                cnpini.getParameter("selector").setValue((Object)new Selector(null, -1){
                    int cnt;
                    {
                        this.cnt = 0;
                    }

                    protected Object[] determineAcceptableProposals(Object[] proposals) {
                        Object[] ret = new Object[]{};
                        ++this.cnt;
                        if (this.cnt == 3) {
                            ret = proposals;
                        }
                        return ret;
                    }
                });
                cnpini.getParameter("iteration_decider").setValue((Object)new IterationDecider(3));
                this.dispatchSubgoalAndWait(cnpini);
                this.getLogger().info("CFP result:" + SUtil.arrayToString((Object)cnpini.getParameterSet("result").getValues()));
                tr.setSucceeded(true);
            }
            catch (GoalFailureException e) {
                tr.setFailed("Exception occurred: " + (Object)((Object)e));
            }
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

