/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.events;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.AuctionInfo;
import jadex.planlib.ExponentialPriceCalculator;
import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.testcases.AbstractMultipleAgentsPlan;
import jadex.util.collection.SCollection;
import java.util.List;
import java.util.Map;

public class EATestPlan
extends AbstractMultipleAgentsPlan {
    public void body() {
        long roundtimeout = 500L;
        Map[] args = new Map[4];
        for (int i = 0; i < args.length; ++i) {
            args[i] = SCollection.createHashMap();
            args[i].put("max_price", new Double(115 + i * 5));
            args[i].put("participate", Boolean.TRUE);
        }
        List agents = this.createAgents("jadex.testcases.events.EABidder", args);
        TestReport tr = new TestReport("#1", "Test with four bidders and a exponential price calculator without variance. Should terminate with a winner!");
        if (this.assureTest(tr)) {
            try {
                IGoal da = this.createGoal("ea_initiate");
                da.getParameterSet("receivers").addValues((Object[])agents.toArray(new AgentIdentifier[agents.size()]));
                ExponentialPriceCalculator pc = new ExponentialPriceCalculator(85.0, 10000.0, 1.1);
                da.getParameter("offer_generator").setValue((Object)pc);
                da.getParameter("auction_info").setValue((Object)new AuctionInfo(System.currentTimeMillis() + 1000L, roundtimeout, (Object)"Test auction 1"));
                this.dispatchSubgoalAndWait(da);
                this.getLogger().info("Auction winner: " + da.getParameter("winner").getValue() + " winning offer: " + da.getParameter("winning_offer").getValue());
                if (da.getParameter("winner").getValue() != null) {
                    tr.setSucceeded(true);
                } else {
                    tr.setFailed("No winner determined though this testcase should terminate with a winner!");
                }
            }
            catch (GoalFailureException e) {
                tr.setFailed("Exception occurred: " + (Object)((Object)e));
            }
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

