/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.capabilities;

import jadex.model.IMBeliefSetReference;
import jadex.model.IMBeliefbase;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.planlib.TestReport;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.Tuple;

public class DynamicCapabilityPlan
extends Plan {
    public void body() {
        this.requestTranslation("1st_request", "not-understood");
        this.addCapability();
        this.requestTranslation("2nd_request", "inform");
        this.removeCapability();
        this.requestTranslation("3rd_request", "not-understood");
    }

    protected void requestTranslation(String testname, String performative) {
        TestReport report = new TestReport(testname, "Request translation (expecting '" + performative + "')");
        try {
            IMessageEvent rtm = this.createMessageEvent("request_translation");
            IMessageEvent res = this.sendMessageAndWait(rtm, 3000L);
            if (performative.equals(res.getParameter("performative").getValue())) {
                report.setSucceeded(true);
            } else {
                report.setReason("Wrong result message: " + res);
            }
        }
        catch (TimeoutException e) {
            report.setReason("No result message received.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)report);
    }

    protected void addCapability() {
        IMCapabilityReference subcap = ((IMCapability)this.getScope().getModelElement()).createCapabilityReference("transcap", "jadex.tutorial.TranslationD2");
        this.getScope().registerSubcapability(subcap);
        this.getLogger().info("Capability transcap successfully added.");
        IMBeliefSetReference belsetref = ((IMBeliefbase)this.getScope().getBeliefbase().getModelElement()).createBeliefSetReference("egwordsref", Tuple.class, "false", "transcap.egwords");
        this.getScope().getBeliefbase().registerBeliefSetReference(belsetref);
        this.getLogger().info("Beliefset reference egwordsref successfully added.");
    }

    protected void removeCapability() {
        IMBeliefSetReference belsetref = ((IMBeliefbase)this.getScope().getBeliefbase().getModelElement()).getBeliefSetReference("egwordsref");
        this.getScope().getBeliefbase().deregisterBeliefSetReference(belsetref);
        ((IMBeliefbase)this.getScope().getBeliefbase().getModelElement()).deleteBeliefSetReference(belsetref);
        this.getLogger().info("Beliefset reference egwordsref successfully added.");
        IMCapabilityReference subcap = ((IMCapability)this.getScope().getModelElement()).getCapabilityReference("transcap");
        this.getScope().deregisterSubcapability(subcap);
        ((IMCapability)this.getScope().getModelElement()).deleteCapabilityReference(subcap);
        this.getLogger().info("Capability transcap successfully removed.");
    }
}

