/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases.beliefs;

import jadex.planlib.TestReport;
import jadex.runtime.Plan;
import jadex.util.collection.BeanChangesArrayList;

public class BeliefSetChangesPlan
extends Plan {
    public void body() {
        TestReport tr = new TestReport("#1", "Test if factadded on belief set causes plan trigger.");
        int before = (Integer)this.getBeliefbase().getBelief("result").getFact();
        this.getLogger().info("Test 1: One should be created in response to addValue of belset_a.");
        this.getLogger().info("belset_a.addFact(\"a4\")");
        this.getBeliefbase().getBeliefSet("belset_a").addFact((Object)"a4");
        this.waitFor(300L);
        int after = (Integer)this.getBeliefbase().getBelief("result").getFact();
        if (before + 1 == after) {
            this.getLogger().info("TEST SUCCEEDED.");
            tr.setSucceeded(true);
        } else {
            this.getLogger().info("TEST FAILED: " + before + " - " + after);
            tr.setReason("One should be created in response to addValue of belset_a.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#2", "Test if factremoved on belief set causes plan trigger.");
        before = (Integer)this.getBeliefbase().getBelief("result").getFact();
        this.getLogger().info("\n\nTest 2: Plan a should be created in response to removeValue of belset_a.");
        this.getLogger().info("belset_a.removeFact(\"a4\")");
        this.getBeliefbase().getBeliefSet("belset_a").removeFact((Object)"a1");
        this.waitFor(300L);
        after = (Integer)this.getBeliefbase().getBelief("result").getFact();
        if (before == after + 1) {
            this.getLogger().info("TEST SUCCEEDED.");
            tr.setSucceeded(true);
        } else {
            this.getLogger().info("TEST FAILED: " + before + " - " + after);
            tr.setReason("Plan a should be created in response to removeValue of belset_a.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        this.getLogger().info("-----------------------------------------------");
        tr = new TestReport("#3", "Test if setting same value does not provoke invocations.");
        before = (Integer)this.getBeliefbase().getBelief("result").getFact();
        this.getLogger().info("\n\nTest 3: A new value is stored in the belief bel.As it is equal no change events will be propagated");
        this.getBeliefbase().getBelief("bel").setFact((Object)new BeanChangesArrayList());
        this.waitFor(300L);
        after = (Integer)this.getBeliefbase().getBelief("result").getFact();
        if (before == after) {
            this.getLogger().info("TEST SUCCEEDED.");
            tr.setSucceeded(true);
        } else {
            this.getLogger().info("TEST FAILED: " + before + " - " + after);
            tr.setReason("Setting same value on bel invoked a plan.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#4", "Test if dependent belset recognizes same value.");
        before = (Integer)this.getBeliefbase().getBelief("result").getFact();
        this.getLogger().info("\n\nTest 4: The fact of bel is provoked to throw a bean property change by calling the modified() method. As the belset does not have changed considering its content no plan is invoked");
        BeanChangesArrayList a = (BeanChangesArrayList)this.getBeliefbase().getBelief("bel").getFact();
        a.modified();
        this.waitFor(300L);
        after = (Integer)this.getBeliefbase().getBelief("result").getFact();
        if (before == after) {
            this.getLogger().info("TEST SUCCEEDED.");
            tr.setSucceeded(true);
        } else {
            this.getLogger().info("TEST FAILED: " + before + " - " + after);
            tr.setReason("Setting same value on belset invoked a plan");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#5", "Add indirectly a value to belset.");
        this.getLogger().info("\n\nTest 5: a new value is added causing a bean property change event that leads to plan invocation.");
        before = (Integer)this.getBeliefbase().getBelief("result").getFact();
        a.add((Object)"a");
        this.waitFor(300L);
        after = (Integer)this.getBeliefbase().getBelief("result").getFact();
        if (before + 1 == after) {
            this.getLogger().info("TEST SUCCEEDED.");
            tr.setSucceeded(true);
        } else {
            this.getLogger().info("TEST FAILED: " + before + " - " + after);
            tr.setReason("No plan was invoked.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#6", "Test if added fact can be accessed.");
        String newfact = "a new fact";
        this.getBeliefbase().getBeliefSet("belset_b").addFact((Object)newfact);
        this.waitFor(200L);
        if (this.getBeliefbase().getBelief("result_b").getFact() != null) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Fact could not be accessed via '$addedfact'.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
        tr = new TestReport("#7", "Test if removed fact can be accessed.");
        this.getBeliefbase().getBelief("result_b").setFact(null);
        this.getBeliefbase().getBeliefSet("belset_b").removeFact((Object)newfact);
        this.waitFor(200L);
        if (this.getBeliefbase().getBelief("result_b").getFact() != null) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Fact could not be accessed via '$removedfact'.");
        }
        this.getBeliefbase().getBeliefSet("reports").addFact((Object)tr);
    }
}

