/*
 * Decompiled with CFR 0.152.
 */
package jadex.testcases;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.util.collection.SCollection;
import java.util.List;
import java.util.Map;

public abstract class AbstractMultipleAgentsPlan
extends Plan {
    protected List agents;
    protected int agent_cnt;

    protected List createAgents(String type, Map[] args) {
        return this.createAgents(type, null, args);
    }

    protected List createAgents(String type, String config, Map[] args) {
        if (this.agents != null) {
            throw new RuntimeException("Create agents is intended to be called only when previous agents have been killed");
        }
        this.agent_cnt = args.length;
        this.agents = SCollection.createArrayList();
        try {
            for (int i = 0; i < args.length; ++i) {
                IGoal ca = this.createGoal("ams_create_agent");
                ca.getParameter("type").setValue((Object)type);
                if (config != null) {
                    ca.getParameter("configuration").setValue((Object)config);
                }
                if (args[i] != null) {
                    ca.getParameter("arguments").setValue((Object)args[i]);
                }
                this.dispatchSubgoalAndWait(ca);
                this.agents.add(ca.getParameter("agentidentifier").getValue());
            }
        }
        catch (GoalFailureException e) {
            this.getLogger().severe("Exception while creating the agents of testcase: " + (Object)((Object)e));
        }
        return this.agents;
    }

    protected void destroyAgents(List agents) {
        if (agents == null) {
            throw new RuntimeException("Destroy agents is intended to be called only when agents have been created");
        }
        for (int i = 0; i < agents.size(); ++i) {
            try {
                IGoal da = this.createGoal("ams_destroy_agent");
                da.getParameter("agentidentifier").setValue(agents.get(i));
                this.dispatchSubgoalAndWait(da);
                continue;
            }
            catch (GoalFailureException e) {
                this.getLogger().severe("Exception while destroying agent: " + agents.get(i));
            }
        }
        agents = null;
    }

    protected boolean assureTest(TestReport tr) {
        boolean ret;
        boolean bl = ret = this.agents.size() == this.agent_cnt;
        if (!ret) {
            tr.setFailed("Not all agents could be created");
        }
        return ret;
    }

    public void passed() {
        this.destroyAgents(this.agents);
    }

    public void failed() {
        this.destroyAgents(this.agents);
    }

    public void aborted() {
        this.destroyAgents(this.agents);
    }
}

