/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle.mobile;

import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.Move;
import jadex.runtime.IEvent;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalEvent;
import jadex.runtime.IInternalEvent;
import jadex.runtime.MobilePlan;

public class MovePlan
extends MobilePlan {
    protected Move move = (Move)this.getParameter("move").getValue();
    protected int depth = (Integer)this.getParameter("depth").getValue();
    protected long delay = (Long)this.getBeliefbase().getBelief("move_delay").getFact();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void action(IEvent event) {
        IBoard board = (IBoard)this.getBeliefbase().getBelief("board").getFact();
        if (event instanceof IGoalEvent && !((IGoalEvent)event).isInfo()) {
            int triescnt = (Integer)this.getBeliefbase().getBelief("triescnt").getFact() + 1;
            this.getBeliefbase().getBelief("triescnt").setFact((Object)new Integer(triescnt));
            this.print("Trying " + this.move + " (" + triescnt + ") ", this.depth);
            board.move(this.move);
            this.waitFor(this.delay);
        } else if (event instanceof IInternalEvent && !board.isSolution()) {
            IGoal mm = this.createGoal("makemove");
            mm.getParameter("depth").setValue((Object)new Integer(this.depth + 1));
            this.dispatchSubgoalAndWait(mm);
        }
    }

    public void failed(IEvent event) {
        this.print("Failed " + this.move, this.depth);
        IBoard board = (IBoard)this.getBeliefbase().getBelief("board").getFact();
        if (!$assertionsDisabled && !board.getLastMove().equals(this.move)) {
            throw new AssertionError((Object)"Tries to takeback wrong move.");
        }
        board.takeback();
    }

    public void passed(IEvent event) {
        this.print("Succeeded " + this.move, this.depth);
    }

    public void aborted(IEvent event) {
        this.print("Aborted " + (this.isAbortedOnSuccess() ? "on success: " : "on failure: ") + this.move, this.depth);
    }

    protected void print(String text, int indent) {
        for (int x = 0; x < indent; ++x) {
            System.out.print(" ");
        }
        System.out.println(text);
    }

    static {
        $assertionsDisabled = !MovePlan.class.desiredAssertionStatus();
    }
}

