/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle.mobile;

import jadex.examples.puzzle.BoardControlPanel;
import jadex.examples.puzzle.BoardPanel;
import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.mobile.BoardListener;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.util.SGUI;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class BoardGui
extends JFrame {
    protected IBoard board;
    protected IExternalAccess agent;
    protected IAgentListener listener;

    public BoardGui(IExternalAccess agent, IBoard board) {
        this(agent, board, false);
    }

    public BoardGui(IExternalAccess agent, IBoard board, boolean controls) {
        this.agent = agent;
        this.board = board;
        BoardPanel bp = new BoardPanel(board);
        this.getContentPane().add("Center", bp);
        this.board.addPropertyChangeListener(new BoardListener(board, bp));
        if (controls) {
            BoardControlPanel bcp = new BoardControlPanel(board, bp);
            this.getContentPane().add("South", bcp);
        }
        this.setTitle("Puzzle Board");
        this.setSize(400, 400);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BoardGui.this.agent.killAgent();
            }
        });
        this.listener = new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ BoardGui access$000(2 x0) {
                return x0.BoardGui.this;
            }
        };
        agent.addAgentListener(this.listener, false);
    }

    public void migrationCleanup() {
        this.agent.removeAgentListener(this.listener);
    }
}

