/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle.humanplayer;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.Move;
import jadex.examples.puzzle.humanplayer.RequestMove;
import jadex.examples.puzzle.humanplayer.RequestTakeback;
import jadex.runtime.ICapability;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IMessageEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BoardObserver {
    public BoardObserver(IBoard board, final ICapability capa) {
        board.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                IExternalAccess ex = capa.getExternalAccess();
                if ("move".equals(evt.getPropertyName())) {
                    AgentIdentifier hp = (AgentIdentifier)ex.getBeliefbase().getBelief("humanplayer").getFact();
                    Move move = (Move)evt.getNewValue();
                    IMessageEvent rmm = ex.createMessageEvent("request_move");
                    RequestMove rm = new RequestMove(move.getStart());
                    rmm.getParameterSet("receivers").addValue((Object)hp);
                    rmm.setContent((Object)rm);
                    if (ex.sendMessageAndWait(rmm, 3000L).getParameter("performative").equals("failure")) {
                        System.out.println("Could not perform move :-(");
                    }
                } else if ("takeback".equals(evt.getPropertyName())) {
                    AgentIdentifier hp = (AgentIdentifier)ex.getBeliefbase().getBelief("humanplayer").getFact();
                    IMessageEvent rmm = ex.createMessageEvent("request_takeback");
                    RequestTakeback rt = new RequestTakeback();
                    rmm.getParameterSet("receivers").addValue((Object)hp);
                    rmm.setContent((Object)rt);
                    if (ex.sendMessageAndWait(rmm, 3000L).getParameter("performative").equals("failure")) {
                        System.out.println("Could not perform takeback :-(");
                    }
                }
            }
        });
    }
}

