/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle;

import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.Move;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;

public class MovePlan
extends Plan {
    protected Move move = (Move)this.getParameter("move").getValue();
    protected int depth = (Integer)this.getParameter("depth").getValue();
    protected long delay = (Long)this.getBeliefbase().getBelief("move_delay").getFact();
    protected IBoard board = (IBoard)this.getBeliefbase().getBelief("board").getFact();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void body() {
        int triescnt = (Integer)this.getBeliefbase().getBelief("triescnt").getFact() + 1;
        this.getBeliefbase().getBelief("triescnt").setFact((Object)new Integer(triescnt));
        this.print("Trying " + this.move + " (" + triescnt + ") ", this.depth);
        this.startAtomic();
        this.board.move(this.move);
        this.endAtomic();
        this.waitFor(this.delay);
        IGoal mm = this.createGoal("makemove");
        mm.getParameter("depth").setValue((Object)new Integer(this.depth + 1));
        this.dispatchSubgoalAndWait(mm);
    }

    public void failed() {
        this.print("Failed " + this.move, this.depth);
        if (!$assertionsDisabled && !this.board.getLastMove().equals(this.move)) {
            throw new AssertionError((Object)"Tries to takeback wrong move.");
        }
        this.board.takeback();
        this.waitFor(this.delay);
    }

    public void passed() {
        this.print("Succeeded " + this.move, this.depth);
    }

    public void aborted() {
        this.print("Aborted " + (this.isAbortedOnSuccess() ? "on success: " : "on failure: ") + this.move, this.depth);
    }

    protected void print(String text, int indent) {
        for (int x = 0; x < indent; ++x) {
            System.out.print(" ");
        }
        System.out.println(text);
    }

    static {
        $assertionsDisabled = !MovePlan.class.desiredAssertionStatus();
    }
}

