/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle;

import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.Move;
import jadex.examples.puzzle.Piece;
import jadex.examples.puzzle.Position;
import jadex.util.SimplePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class JackBoard
implements IBoard,
Serializable {
    protected Piece white_piece = new Piece(true);
    protected Piece black_piece = new Piece(false);
    protected ArrayList moves = new ArrayList();
    public SimplePropertyChangeSupport pcs = new SimplePropertyChangeSupport((Object)this);
    int[][] board = new int[][]{{1, 1, 1, 4, 4}, {1, 1, 1, 4, 4}, {1, 1, 0, -1, -1}, {4, 4, -1, -1, -1}, {4, 4, -1, -1, -1}};
    int last = 4;
    Position the_hole = new Position(2, 2);
    static int[][] move_check_table = new int[][]{{1, 0, -1}, {0, 1, -1}, {-1, 0, 1}, {0, -1, 1}, {2, 0, -1, 1, 0, 1}, {0, 2, -1, 0, 1, 1}, {-2, 0, 1, -1, 0, -1}, {0, -2, 1, 0, -1, -1}};

    public Piece getPiece(Position pos) {
        int piece = this.get(pos.getX(), pos.getY());
        if (piece == 1) {
            return this.white_piece;
        }
        if (piece == -1) {
            return this.black_piece;
        }
        return null;
    }

    public List getPossibleMoves() {
        ArrayList<Move> ret = new ArrayList<Move>();
        Vector ts = this.moves(this.the_hole);
        for (int i = 0; i < ts.size(); ++i) {
            ret.add(new Move((Position)ts.get(i), this.the_hole));
        }
        return ret;
    }

    public boolean move(Move move) {
        int p = this.get(move.getStart());
        this.set(0, move.getStart());
        this.the_hole = move.getStart();
        this.set(p, move.getEnd());
        this.moves.add(move);
        this.pcs.firePropertyChange("move", null, (Object)move);
        return true;
    }

    public boolean takeback() {
        if (this.moves.size() == 0) {
            return false;
        }
        Move move = (Move)this.moves.get(this.moves.size() - 1);
        int p = this.get(move.getEnd());
        this.set(p, move.getStart());
        this.set(0, move.getEnd());
        this.the_hole = move.getEnd();
        this.moves.remove(this.moves.size() - 1);
        this.pcs.firePropertyChange("takeback", null, (Object)move);
        return true;
    }

    public boolean isSolution() {
        return this.solution();
    }

    public List getMoves() {
        return this.moves;
    }

    public Move getLastMove() {
        return this.moves.size() > 0 ? (Move)this.moves.get(this.moves.size() - 1) : null;
    }

    public boolean wasLastMoveWhite() {
        Move move = this.getLastMove();
        return move == null || this.get(move.getEnd()) == 1;
    }

    public int getSize() {
        return 5;
    }

    public List getCurrentPosition() {
        ArrayList<Piece> ret = new ArrayList<Piece>();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                ret.add(this.getPiece(new Position(x, y)));
            }
        }
        return ret;
    }

    public boolean isFreePosition(Position pos) {
        int y;
        int x = pos.getX();
        return this.get(x, y = pos.getY()) == 0;
    }

    Vector moves(int x, int y) {
        Vector v = new Vector();
        for (int i = 0; i < move_check_table.length; ++i) {
            this.check(v, move_check_table[i], x, y);
        }
        return v;
    }

    void check(Vector v, int[] m, int x, int y) {
        int x1 = x + m[0];
        int y1 = y + m[1];
        if (this.get(x1, y1) == m[2] && (m.length == 3 || this.get(x + m[3], y + m[4]) == m[5])) {
            Position s = new Position(x1, y1);
            v.add(s);
        }
    }

    int get(int x, int y) {
        if (x < 0 || x >= 5 || y < 0 || y >= 5) {
            return 4;
        }
        return this.board[x][y];
    }

    int get(Position s) {
        return this.get(s.x, s.y);
    }

    void set(int v, int x, int y) {
        this.board[x][y] = v;
    }

    void set(int v, Position s) {
        this.set(v, s.x, s.y);
    }

    boolean solution() {
        if (this.board[2][2] != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.board[i][j] <= 0) continue;
                return false;
            }
        }
        return true;
    }

    Vector moves(Position hole) {
        return this.moves(hole.x, hole.y);
    }

    boolean isJumpMove(int x, int y) {
        int dx = Math.abs(this.the_hole.x - x);
        int dy = Math.abs(this.the_hole.y - y);
        return dx == 2 || dy == 2;
    }

    boolean isJumpMove(Position s) {
        return this.isJumpMove(s.x, s.y);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

