/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle;

import jadex.examples.puzzle.Board;
import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.Move;
import jadex.examples.puzzle.Piece;
import jadex.examples.puzzle.Position;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;

public class BoardPanel
extends JPanel {
    public static UIDefaults icons = new UIDefaults(new Object[]{"white_piece", SGUI.makeIcon((Class)BoardPanel.class, (String)"images/white_piece.png"), "red_piece", SGUI.makeIcon((Class)BoardPanel.class, (String)"images/red_piece.png"), "empty_field", SGUI.makeIcon((Class)BoardPanel.class, (String)"images/empty_field.png")});
    protected IBoard board;
    protected boolean rescale;
    protected Image wp_image;
    protected Image rp_image;
    protected Image ef_image;
    protected JLabel white_piece;
    protected JLabel red_piece;
    protected JLabel empty_field;
    protected PropertyChangeEvent lastevent;
    protected List listeners = new ArrayList();

    public BoardPanel(IBoard board) {
        this.board = board;
        this.wp_image = ((ImageIcon)icons.getIcon("white_piece")).getImage();
        this.rp_image = ((ImageIcon)icons.getIcon("red_piece")).getImage();
        this.ef_image = ((ImageIcon)icons.getIcon("empty_field")).getImage();
        this.white_piece = new JLabel(new ImageIcon(this.wp_image), 0);
        this.red_piece = new JLabel(new ImageIcon(this.rp_image), 0);
        this.empty_field = new JLabel(new ImageIcon(this.ef_image), 0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                BoardPanel.this.rescale = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int size = BoardPanel.this.board.getSize();
                Rectangle r = BoardPanel.this.getBounds();
                int x = (int)((double)e.getX() / (r.getWidth() / (double)size));
                int y = (int)((double)e.getY() / (r.getHeight() / (double)size));
                int m = size / 2;
                if (!(x < m && y > m || x > m && y < m)) {
                    ActionEvent ae = new ActionEvent(new Position(x, y), 0, null);
                    for (int i = 0; i < BoardPanel.this.listeners.size(); ++i) {
                        ((ActionListener)BoardPanel.this.listeners.get(i)).actionPerformed(ae);
                    }
                }
            }
        });
    }

    public void update(PropertyChangeEvent evt) {
        this.lastevent = evt;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        int bsize = this.board.getSize();
        Rectangle bounds = this.getBounds();
        double cellw = bounds.getWidth() / (double)bsize;
        double cellh = bounds.getHeight() / (double)bsize;
        if (this.rescale) {
            ((ImageIcon)this.white_piece.getIcon()).setImage(this.wp_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.red_piece.getIcon()).setImage(this.rp_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.empty_field.getIcon()).setImage(this.ef_image.getScaledInstance((int)cellw, (int)cellh, 1));
            this.rescale = false;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, bounds.width, bounds.height);
        List pieces = this.board.getCurrentPosition();
        for (int y = 0; y < bsize; ++y) {
            for (int x = 0; x < bsize; ++x) {
                Piece piece = (Piece)pieces.get(y * bsize + x);
                if (piece != null) {
                    if (piece.isWhite()) {
                        SGUI.renderObject((Graphics)g, (Component)this.white_piece, (double)cellw, (double)cellh, (int)x, (int)y, (int)0);
                        continue;
                    }
                    SGUI.renderObject((Graphics)g, (Component)this.red_piece, (double)cellw, (double)cellh, (int)x, (int)y, (int)0);
                    continue;
                }
                if (!this.board.isFreePosition(new Position(x, y))) continue;
                SGUI.renderObject((Graphics)g, (Component)this.empty_field, (double)cellw, (double)cellh, (int)x, (int)y, (int)0);
            }
        }
        if (this.lastevent != null) {
            if (this.lastevent.getPropertyName().equals("move")) {
                g.setColor(Color.green);
                this.drawArrow(g, (Move)this.lastevent.getNewValue(), cellw, cellh);
            } else if (this.lastevent.getPropertyName().equals("takeback")) {
                g.setColor(Color.red);
                Move m = (Move)this.lastevent.getNewValue();
                Move tb = new Move(m.getEnd(), m.getStart());
                this.drawArrow(g, tb, cellw, cellh);
            }
        }
    }

    protected void drawArrow(Graphics g, Move move, double cellw, double cellh) {
        int xs = move.getStart().getX();
        int ys = move.getStart().getY();
        int xe = move.getEnd().getX();
        int ye = move.getEnd().getY();
        int xms = (int)((double)xs * cellw + cellw / 2.0);
        int yms = (int)((double)ys * cellh + cellh / 2.0);
        int xme = (int)((double)xe * cellw + cellw / 2.0);
        int yme = (int)((double)ye * cellh + cellh / 2.0);
        int asize = Math.max((int)(Math.min(cellw, cellh) / 8.0), 1);
        int thick = Math.max(asize / 4, 1);
        if (xs < xe) {
            g.fillRect(xms, yms - thick / 2, xme - xms - asize, thick);
            g.fillPolygon(new int[]{xme - asize, xme - asize, xme}, new int[]{yme - asize, yme + asize, yme}, 3);
        } else if (xs > xe) {
            g.fillRect(xme + asize, yms - thick / 2, xms - xme - asize, thick);
            g.fillPolygon(new int[]{xme + asize, xme + asize, xme}, new int[]{yme - asize, yme + asize, yme}, 3);
        } else if (ys < ye) {
            g.fillRect(xms - thick / 2, yms, thick, yme - yms - asize);
            g.fillPolygon(new int[]{xme - asize, xme + asize, xme}, new int[]{yme - asize, yme - asize, yme}, 3);
        } else {
            g.fillRect(xms - thick / 2, yme + asize, thick, yms - yme - asize);
            g.fillPolygon(new int[]{xme - asize, xme + asize, xme}, new int[]{yme + asize, yme + asize, yme}, 3);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public static void main(String[] args) {
        Board b = new Board(5);
        BoardPanel bp = new BoardPanel(b);
        bp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Action event: " + e);
            }
        });
        JFrame f = new JFrame();
        f.getContentPane().add("Center", bp);
        f.setSize(400, 400);
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
    }
}

