/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.puzzle;

import jadex.examples.puzzle.IBoard;
import jadex.examples.puzzle.Move;
import jadex.examples.puzzle.Piece;
import jadex.examples.puzzle.Position;
import jadex.util.SimplePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Board
implements IBoard,
Serializable {
    protected ArrayList moves = new ArrayList();
    protected HashMap pieces = new HashMap();
    protected int size;
    protected Position hole_pos;
    public SimplePropertyChangeSupport pcs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Board() {
        this(5);
    }

    public Board(int size) {
        this.size = size;
        this.pcs = new SimplePropertyChangeSupport((Object)this);
        int middle = size / 2;
        this.hole_pos = new Position(middle, middle);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                if (x == middle && y == middle) continue;
                if (x <= middle && y <= middle) {
                    this.pieces.put(new Position(x, y), new Piece(true));
                    continue;
                }
                if (x < middle || y < middle) continue;
                this.pieces.put(new Position(x, y), new Piece(false));
            }
        }
    }

    public synchronized Piece getPiece(Position pos) {
        return (Piece)this.pieces.get(pos);
    }

    public synchronized List getPossibleMoves() {
        ArrayList<Move> ret = new ArrayList<Move>();
        int hx = this.hole_pos.getX();
        int hy = this.hole_pos.getY();
        int[] cols = new int[]{-1, -1, 1, 1, -1, -1, 1, 1};
        Position[] fig_pos = new Position[]{new Position(hx + 1, hy), new Position(hx, hy + 1), new Position(hx - 1, hy), new Position(hx, hy - 1), new Position(hx + 2, hy), new Position(hx, hy + 2), new Position(hx - 2, hy), new Position(hx, hy - 2)};
        for (int i = 0; i < fig_pos.length; ++i) {
            int white_piece;
            int white = cols[i];
            boolean jump = i >= fig_pos.length / 2;
            Piece piece = this.getPiece(fig_pos[i]);
            if (piece == null) continue;
            int n = white_piece = piece.isWhite() ? 1 : -1;
            if (white_piece != white) continue;
            if (!jump) {
                if (!$assertionsDisabled && !this.isPossibleMove(new Move(fig_pos[i], this.hole_pos))) {
                    throw new AssertionError();
                }
                ret.add(new Move(fig_pos[i], this.hole_pos));
                continue;
            }
            Piece jp = this.getPiece(fig_pos[i - fig_pos.length / 2]);
            if (jp == null || jp.isWhite() == piece.isWhite()) continue;
            if (!$assertionsDisabled && !this.isPossibleMove(new Move(fig_pos[i], this.hole_pos))) {
                throw new AssertionError();
            }
            ret.add(new Move(fig_pos[i], this.hole_pos));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(Move move) {
        Board board = this;
        synchronized (board) {
            if (!this.isPossibleMove(move)) {
                return false;
            }
            Piece piece = this.getPiece(move.getStart());
            this.pieces.remove(move.getStart());
            this.pieces.put(move.getEnd(), piece);
            this.moves.add(move);
            this.hole_pos = move.getStart();
        }
        this.pcs.firePropertyChange("move", null, (Object)move);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeback() {
        Move move;
        Board board = this;
        synchronized (board) {
            if (this.moves.size() == 0) {
                return false;
            }
            move = (Move)this.moves.get(this.moves.size() - 1);
            Piece piece = this.getPiece(move.getEnd());
            this.pieces.remove(move.getEnd());
            this.pieces.put(move.getStart(), piece);
            this.moves.remove(this.moves.size() - 1);
            this.hole_pos = move.getEnd();
        }
        this.pcs.firePropertyChange("takeback", null, (Object)move);
        return true;
    }

    public synchronized boolean isSolution() {
        int middle = this.size / 2;
        if (!this.isFreePosition(new Position(middle, middle))) {
            return false;
        }
        boolean ret = true;
        for (int y = 0; y < this.size && ret; ++y) {
            for (int x = 0; x < this.size && ret; ++x) {
                if (x == middle && y == middle) continue;
                if (x <= middle && y <= middle && this.getPiece(new Position(x, y)).isWhite()) {
                    ret = false;
                    continue;
                }
                if (x < middle || y < middle || this.getPiece(new Position(x, y)).isWhite()) continue;
                ret = false;
            }
        }
        return ret;
    }

    public synchronized List getMoves() {
        return Collections.unmodifiableList(this.moves);
    }

    public synchronized Move getLastMove() {
        return this.moves.size() > 0 ? (Move)this.moves.get(this.moves.size() - 1) : null;
    }

    public synchronized boolean wasLastMoveWhite() {
        boolean ret = true;
        if (this.moves.size() > 0) {
            Move last = (Move)this.moves.get(this.moves.size() - 1);
            ret = this.getPiece(last.getEnd()).isWhite();
        }
        return ret;
    }

    public synchronized boolean isFreePosition(Position pos) {
        int middle = this.size / 2;
        int x = pos.getX();
        int y = pos.getY();
        return this.pieces.get(pos) == null && x >= 0 && y >= 0 && x < this.size && y < this.size && (x <= middle && y <= middle || x >= middle && y >= middle);
    }

    protected boolean isPossibleMove(Move move) {
        boolean jumpmove;
        Piece piece = this.getPiece(move.getStart());
        if (piece == null || !this.isFreePosition(move.getEnd())) {
            return false;
        }
        int turn = piece.isWhite() ? 1 : -1;
        int xs = move.getStart().getX();
        int ys = move.getStart().getY();
        int xe = move.getEnd().getX();
        int ye = move.getEnd().getY();
        boolean normalmove = (xe - xs) * turn == 1 && ye - ys == 0 || (ye - ys) * turn == 1 && xe - xs == 0;
        Position xin = new Position(xs + turn, ys);
        Position yin = new Position(xs, ys + turn);
        boolean bl = jumpmove = (xe - xs) * turn == 2 && ye - ys == 0 && !this.isFreePosition(xin) && this.getPiece(xin).isWhite() != piece.isWhite() || (ye - ys) * turn == 2 && xe - xs == 0 && !this.isFreePosition(yin) && this.getPiece(yin).isWhite() != piece.isWhite();
        return normalmove || jumpmove;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized List getCurrentPosition() {
        ArrayList<Piece> ret = new ArrayList<Piece>();
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                ret.add(this.getPiece(new Position(x, y)));
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                sbuf.append("x=" + x + " y=" + y + " :" + this.getPiece(new Position(x, y)));
            }
        }
        return sbuf.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static void main(String[] args) {
        Board board = new Board(5);
        List moves = board.getPossibleMoves();
        System.out.println(moves);
        board.move((Move)moves.get(0));
        moves = board.getPossibleMoves();
        System.out.println(moves);
        board.move((Move)moves.get(0));
        System.out.println(board.isPossibleMove(new Move(new Position(2, 0), new Position(2, 2))));
        System.out.println(board.isPossibleMove(new Move(new Position(4, 2), new Position(5, 2))));
        board.move((Move)moves.get(0));
        System.out.println(board.getPossibleMoves());
    }

    static {
        $assertionsDisabled = !Board.class.desiredAssertionStatus();
    }
}

