/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.marsworld.sentry;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.SearchConstraints;
import jadex.adapter.fipa.ServiceDescription;
import jadex.examples.marsworld.RequestProduction;
import jadex.examples.marsworld.Target;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;

public class AnalyseTargetPlan
extends Plan {
    public AnalyseTargetPlan() {
        this.getLogger().info("Created: " + (Object)((Object)this));
    }

    public void body() {
        Target target = (Target)this.getParameter("target").getValue();
        IGoal go_target = this.createGoal("move_dest");
        go_target.getParameter("destination").setValue((Object)target.getLocation());
        this.dispatchSubgoalAndWait(go_target);
        this.waitFor(1000L);
        target.setMarked();
        if (target.getOreCapacity() > 0) {
            this.callProductionAgent(target);
        }
        this.startAtomic();
        this.getBeliefbase().getBeliefSet("analysed_targets").addFact((Object)target);
        this.getBeliefbase().getBeliefSet("my_targets").removeFact((Object)target);
        this.endAtomic();
    }

    private void callProductionAgent(Target target) {
        ServiceDescription sd = new ServiceDescription("service_produce", null, null);
        AgentDescription dfadesc = new AgentDescription();
        dfadesc.addService(sd);
        SearchConstraints constraints = new SearchConstraints();
        constraints.setMaxResults(-1);
        IGoal ft = this.createGoal("df_search");
        ft.getParameter("description").setValue((Object)dfadesc);
        ft.getParameter("constraints").setValue((Object)constraints);
        this.dispatchSubgoalAndWait(ft);
        AgentDescription[] producers = (AgentDescription[])ft.getParameterSet("result").getValues();
        if (producers.length > 0) {
            int sel = (int)(Math.random() * (double)producers.length);
            RequestProduction rp = new RequestProduction();
            rp.setTarget(target);
            IMessageEvent mevent = this.createMessageEvent("request_producer");
            mevent.getParameterSet("receivers").addValue((Object)producers[sel].getName());
            mevent.setContent((Object)rp);
            this.sendMessage(mevent);
        }
    }
}

