/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.marsworld.manager;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.marsworld.AgentInfo;
import jadex.examples.marsworld.Environment;
import jadex.examples.marsworld.Homebase;
import jadex.examples.marsworld.Location;
import jadex.examples.marsworld.Target;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;

public class MarsworldGui
extends JFrame {
    private static UIDefaults icons = new UIDefaults(new Object[]{"background", SGUI.makeIcon((Class)MarsworldGui.class, (String)"../images/mars.png"), "homebase", SGUI.makeIcon((Class)MarsworldGui.class, (String)"../images/homebase.png"), "target", SGUI.makeIcon((Class)MarsworldGui.class, (String)"../images/target.png"), "sentry", SGUI.makeIcon((Class)MarsworldGui.class, (String)"../images/sentryagent.png"), "production", SGUI.makeIcon((Class)MarsworldGui.class, (String)"../images/productionagent.png"), "carry", SGUI.makeIcon((Class)MarsworldGui.class, (String)"../images/carryagent.png")});
    protected Timer timer;
    protected JPanel map;

    public MarsworldGui(final IExternalAccess agent) {
        super("Mars Environment - Agents collecting ore from targets...");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AgentIdentifier[] as = (AgentIdentifier[])agent.getBeliefbase().getBeliefSet("startedagents").getFacts();
                for (int i = 0; i < as.length; ++i) {
                    try {
                        IGoal kg = agent.createGoal("ams_destroy_agent");
                        kg.getParameter("agentidentifier").setValue((Object)as[i]);
                        agent.dispatchTopLevelGoalAndWait(kg);
                        continue;
                    }
                    catch (GoalFailureException gfe) {
                        // empty catch block
                    }
                }
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).timer.stop();
                        2.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ MarsworldGui access$000(2 x0) {
                return x0.MarsworldGui.this;
            }
        }, false);
        Environment env = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
        this.map = this.createMarsworldPanel(env);
        JLabel sentrylabel = new JLabel(": Sentry Agent", icons.getIcon("sentry"), 10);
        JLabel prodname = new JLabel(": Production Agent", icons.getIcon("production"), 10);
        JLabel carryname = new JLabel(": Carry Agent", icons.getIcon("carry"), 10);
        JLabel homename = new JLabel(": Homebase", icons.getIcon("homebase"), 10);
        JLabel targetname = new JLabel(": Target", icons.getIcon("target"), 10);
        JTextPane helptext = new JTextPane();
        helptext.setText("A group of robots is searching for ore on Mars...\n\nThis example was inspired by the book 'Multiagentsystems' written by Jaques Ferber.");
        helptext.setEnabled(false);
        helptext.setEditable(false);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(homename);
        p1.add(sentrylabel);
        p1.add(prodname);
        p1.add(carryname);
        p1.add(targetname);
        p1.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridBagLayout());
        p2.add((Component)helptext, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        p2.setBorder(BorderFactory.createTitledBorder(null, "Mars Robots", 0, 0, null, null));
        Insets insets = new Insets(2, 4, 2, 4);
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.add((Component)this.map, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, insets, 0, 0));
        content.add((Component)p1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        content.add((Component)p2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        content.add((Component)new JPanel(), new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        content.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        content.setEnabled(false);
        p2.setMinimumSize(new Dimension((int)p1.getMinimumSize().getWidth(), 160));
        p2.setPreferredSize(new Dimension((int)p1.getPreferredSize().getWidth(), 160));
        this.setContentPane(content);
        this.setSize(600, 450);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MarsworldGui.this.map.repaint();
            }
        });
        this.timer.start();
    }

    protected JPanel createMarsworldPanel(final Environment env) {
        JPanel ret = new JPanel(true){
            Map images;
            double scale;
            {
                super(x0);
                this.images = new HashMap();
            }

            protected void paintComponent(Graphics g) {
                double newscale;
                super.paintComponent(g);
                Rectangle bounds = this.getBounds();
                Image image = ((ImageIcon)icons.getIcon("background")).getImage();
                int w = image.getWidth(this);
                int h = image.getHeight(this);
                if (w > 0 && h > 0) {
                    for (int y = 0; y < bounds.height; y += h) {
                        for (int x = 0; x < bounds.width; x += w) {
                            g.drawImage(image, x, y, this);
                        }
                    }
                }
                if ((newscale = bounds.getWidth() / 600.0) != this.scale) {
                    this.scale = newscale;
                    Image img = ((ImageIcon)icons.getIcon("sentry")).getImage();
                    int wx = (int)((double)img.getWidth(this) * this.scale);
                    int wy = (int)((double)img.getHeight(this) * this.scale);
                    if (wx > 0 && wy > 0) {
                        this.images.put("sentry_agent", img.getScaledInstance(wx, wy, 1));
                    }
                    img = ((ImageIcon)icons.getIcon("production")).getImage();
                    wx = (int)((double)img.getWidth(this) * this.scale);
                    wy = (int)((double)img.getHeight(this) * this.scale);
                    if (wx > 0 && wy > 0) {
                        this.images.put("production_agent", img.getScaledInstance(wx, wy, 1));
                    }
                    img = ((ImageIcon)icons.getIcon("carry")).getImage();
                    wx = (int)((double)img.getWidth(this) * this.scale);
                    wy = (int)((double)img.getHeight(this) * this.scale);
                    if (wx > 0 && wy > 0) {
                        this.images.put("carry_agent", img.getScaledInstance(wx, wy, 1));
                    }
                }
                AgentInfo[] infos = env.getAgentInfos();
                for (int i = 0; i < infos.length; ++i) {
                    Image img = (Image)this.images.get(infos[i].getType());
                    if (img == null) continue;
                    Location loc = infos[i].getLocation();
                    int x = (int)(loc.getX() * bounds.getWidth());
                    int y = (int)(loc.getY() * bounds.getHeight());
                    int wx = img.getWidth(this);
                    int wy = img.getHeight(this);
                    int vw = (int)(infos[i].getVision() * bounds.getWidth());
                    g.drawImage(img, x - wx / 2, y - wy / 2, this);
                    g.setColor(new Color(250, 250, 30, 50));
                    g.fillOval(x - vw, y - vw, vw * 2, vw * 2);
                    String txt = infos[i].getName();
                    g.setColor(Color.black);
                    g.drawString(txt, x - wx / 2, y + wy / 2 + 12);
                }
                Homebase home = env.getHomebase();
                Location loc = home.getLocation();
                int x = (int)(loc.getX() * bounds.getWidth());
                int y = (int)(loc.getY() * bounds.getHeight());
                int wx = (int)(0.14 * bounds.getWidth());
                int wy = (int)(0.12 * bounds.getWidth());
                g.setColor(new Color(30, 30, 30, 70));
                g.fillRect(x - wx / 2, y - wy / 2, wx, wy);
                g.setColor(Color.black);
                g.drawRect(x - wx / 2, y - wy / 2, wx, wy);
                g.drawString("Collected ore: " + home.getOre(), x - wx / 2, y + wy / 2 + 12);
                SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
                g.drawString("Remaining time: " + sdf.format(new Date(env.getHomebase().getRemainingMissionTime())), x - wx / 2, y + wy / 2 + 22);
                Target[] targets = env.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    loc = targets[i].getLocation();
                    x = (int)(loc.getX() * bounds.getWidth());
                    y = (int)(loc.getY() * bounds.getHeight());
                    int wxy = Math.min(12, Math.max(1, (int)(0.02 * bounds.getWidth())));
                    if (targets[i].isMarked()) {
                        g.setColor(Color.black);
                        g.drawString("ore: " + targets[i].getOre(), x + 20, y);
                        g.drawString("capacity:" + targets[i].getOreCapacity(), x + 10, y + 10);
                        g.setColor(new Color(50, 50, 50, 150));
                    } else {
                        g.setColor(new Color(200, 0, 0, 150));
                    }
                    g.fillOval(x - wxy / 2, y - wxy / 2, wxy, wxy);
                }
            }
        };
        ret.setBorder(BorderFactory.createBevelBorder(1));
        return ret;
    }
}

