/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.marsworld;

import jadex.examples.marsworld.Location;
import jadex.examples.marsworld.TargetData;
import jadex.util.SReflect;

public class Target
extends TargetData {
    protected int ore;
    protected int initialcapacity;
    protected int capacity;
    protected boolean marked;
    protected static int cnt;

    public Target() {
    }

    public Target(Location loc, int initialcapacity) {
        this.setId("target#" + cnt++);
        this.setLocation(loc);
        this.ore = 0;
        this.initialcapacity = initialcapacity;
        this.capacity = initialcapacity;
        this.marked = false;
    }

    public void produceOre(int ore) {
        if (this.capacity < ore) {
            throw new RuntimeException("This target cannot produce more ore!");
        }
        this.ore += ore;
        this.capacity = this.initialcapacity - this.ore;
    }

    public int retrieveOre(int amount) {
        int ret;
        if (amount > this.ore) {
            ret = this.ore;
            this.ore = 0;
        } else {
            ret = amount;
            this.ore -= amount;
        }
        return ret;
    }

    public int getOreCapacity() {
        return this.capacity;
    }

    public int getOre() {
        return this.ore;
    }

    public void setMarked() {
        this.marked = true;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean isOre() {
        return this.capacity > 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getInitialcapacity() {
        return this.initialcapacity;
    }

    public void setInitialcapacity(int initialcapacity) {
        this.initialcapacity = initialcapacity;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public void setOre(int ore) {
        this.ore = ore;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " name=" + this.getId() + ", inicap=" + this.initialcapacity + ", cap=" + this.capacity + ", ore=" + this.ore + ", marked=" + this.marked + " loc=" + this.location;
    }
}

