/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.marsworld;

import jadex.examples.marsworld.LocationData;
import java.io.Serializable;
import nuggets.INugget;

public class Location
extends LocationData
implements Serializable,
INugget {
    public static final double DEFAULT_TOLERANCE = 0.001;

    public Location() {
    }

    public Location(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getDistance(Location other) {
        return Math.sqrt((other.y - this.y) * (other.y - this.y) + (other.x - this.x) * (other.x - this.x));
    }

    public boolean isNear(Location other) {
        return this.isNear(other, 0.001);
    }

    public boolean isNear(Location other, double tolerance) {
        return this.getDistance(other) <= tolerance;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof Location) {
            Location loc = (Location)o;
            if (loc.x == this.x && loc.y == this.y) {
                ret = true;
            }
        }
        return ret;
    }
}

