/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.marsworld;

import jadex.examples.marsworld.AgentInfo;
import jadex.examples.marsworld.Homebase;
import jadex.examples.marsworld.Location;
import jadex.examples.marsworld.Target;
import java.util.ArrayList;

public class Environment {
    public static final String CARRY_AGENT = "carry_agent";
    public static final String PRODUCTION_AGENT = "production_agent";
    public static final String SENTRY_AGENT = "sentry_agent";
    protected ArrayList agentinfos = new ArrayList();
    protected ArrayList targets = new ArrayList();
    protected static Environment instance;
    protected Homebase homebase;

    private Environment() {
        this.targets.add(new Target(new Location(0.1, 0.2), 0));
        this.targets.add(new Target(new Location(0.05, 0.7), 200));
        this.targets.add(new Target(new Location(0.5, 0.6), 0));
        this.targets.add(new Target(new Location(0.8, 0.1), 50));
        this.targets.add(new Target(new Location(0.7, 0.4), 100));
        this.targets.add(new Target(new Location(0.8, 0.8), 25));
        this.homebase = new Homebase(new Location(0.3, 0.3), 90000L);
    }

    public static Environment getInstance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    public static Environment createInstance() {
        instance = new Environment();
        return instance;
    }

    public synchronized Target[] getTargets() {
        return this.targets.toArray(new Target[this.targets.size()]);
    }

    public synchronized Target[] getTargetsNear(Location loc, double tolerance) {
        ArrayList<Target> ret = new ArrayList<Target>();
        for (int i = 0; i < this.targets.size(); ++i) {
            Target tmp = (Target)this.targets.get(i);
            if (!tmp.getLocation().isNear(loc, tolerance)) continue;
            ret.add(tmp);
        }
        return ret.toArray(new Target[ret.size()]);
    }

    public synchronized Homebase getHomebase() {
        return this.homebase;
    }

    public synchronized void setAgentInfo(AgentInfo agentinfo) {
        this.agentinfos.remove(agentinfo);
        this.agentinfos.add(agentinfo);
    }

    public synchronized AgentInfo[] getAgentInfos() {
        return this.agentinfos.toArray(new AgentInfo[this.agentinfos.size()]);
    }

    public synchronized Target getTarget(Location loc) {
        Target ret = null;
        for (int i = 0; i < this.targets.size(); ++i) {
            if (!((Target)this.targets.get(i)).getLocation().isNear(loc)) continue;
            ret = (Target)this.targets.get(i);
        }
        if (ret == null) {
            throw new RuntimeException("No target found for: " + loc + " " + this.targets);
        }
        return ret;
    }

    public synchronized Target getTarget(String id) {
        Target ret = null;
        for (int i = 0; i < this.targets.size(); ++i) {
            if (!((Target)this.targets.get(i)).getId().equals(id)) continue;
            ret = (Target)this.targets.get(i);
        }
        if (ret == null) {
            throw new RuntimeException("No target found for: " + id + " " + this.targets);
        }
        return ret;
    }
}

