/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.environment;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.CurrentVision;
import jadex.examples.hunterprey.Vision;
import jadex.examples.hunterprey.environment.EnvironmentGui;
import jadex.runtime.AgentEvent;
import jadex.runtime.IBeliefListener;
import jadex.runtime.IExternalAccess;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectInputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ObserverGui
extends EnvironmentGui {
    protected long refreshtime;
    protected long refreshinterval;

    public ObserverGui(IExternalAccess agent) {
        super(agent);
    }

    protected JPanel createOptionsPanel(final IExternalAccess agent) {
        JPanel options = new JPanel(new GridBagLayout());
        options.setBorder(new TitledBorder(new EtchedBorder(1), "Observer Control"));
        final JTextField refreshintervaltf = new JTextField("" + this.refreshinterval, 5);
        refreshintervaltf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObserverGui.this.refreshinterval = Math.max(5000L, Long.parseLong(refreshintervaltf.getText()));
                refreshintervaltf.setText("" + ObserverGui.this.refreshinterval);
            }
        });
        JButton refresh = new JButton("Refresh highscore");
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ObserverGui.this.refreshHighscore(agent);
            }
        });
        Insets insets = new Insets(2, 4, 4, 2);
        options.add((Component)new JLabel("Autorefresh highscore [millis, -1 for off]"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)refreshintervaltf, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)refresh, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return options;
    }

    protected void refreshHighscore(IExternalAccess agent) {
        try {
            ObjectInputStream is = new ObjectInputStream(SUtil.getResource((String)((String)agent.getBeliefbase().getBelief("highscore").getFact())));
            Creature[] hscreatures = (Creature[])is.readObject();
            is.close();
            this.highscore.update(hscreatures);
        }
        catch (Exception e) {
            System.out.print("Error loading highscore: ");
            e.printStackTrace();
        }
    }

    protected void enableGuiUpdate(final IExternalAccess agent) {
        agent.getBeliefbase().getBelief("vision").addBeliefListener(new IBeliefListener(){

            public void beliefChanged(AgentEvent ae) {
                Vision vision = (Vision)ae.getValue();
                Creature me = (Creature)agent.getBeliefbase().getBelief("my_self").getFact();
                if (vision != null) {
                    ObserverGui.this.map.update(new CurrentVision(me, vision));
                    ObserverGui.this.creatures.update(vision.getCreatures());
                    ObserverGui.this.observers.update(vision.getCreatures());
                }
                long time = System.currentTimeMillis();
                if (ObserverGui.this.refreshinterval >= 0L && ObserverGui.this.refreshtime + ObserverGui.this.refreshinterval <= time) {
                    ObserverGui.this.refreshHighscore(agent);
                    ObserverGui.this.refreshtime = time;
                }
            }
        }, false);
    }
}

