/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.environment;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.CurrentVision;
import jadex.examples.hunterprey.Environment;
import jadex.examples.hunterprey.Food;
import jadex.examples.hunterprey.Hunter;
import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.Observer;
import jadex.examples.hunterprey.Obstacle;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.WorldObject;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;

public class MapPanel
extends JPanel {
    public static UIDefaults icons = new UIDefaults(new Object[]{"food", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/hunterprey/images/food.png"), "obstacle", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/hunterprey/images/obstacle.png"), "hunter", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/hunterprey/images/hunter.png"), "prey", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/hunterprey/images/prey.png"), "observer", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/hunterprey/images/observer.png"), "background", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/hunterprey/images/background.png")});
    protected CurrentVision cv;
    protected JLabel obstacle;
    protected JLabel food;
    protected JLabel prey;
    protected JLabel hunter;
    protected Image background_image = ((ImageIcon)icons.getIcon("background")).getImage();
    protected Image obstacle_image;
    protected Image food_image = ((ImageIcon)icons.getIcon("food")).getImage();
    protected Image prey_image;
    protected Image hunter_image;
    protected boolean rescale;

    public MapPanel() {
        this.obstacle_image = ((ImageIcon)icons.getIcon("obstacle")).getImage();
        this.hunter_image = ((ImageIcon)icons.getIcon("hunter")).getImage();
        this.prey_image = ((ImageIcon)icons.getIcon("prey")).getImage();
        this.obstacle = new JLabel(new ImageIcon(this.obstacle_image), 0);
        this.food = new JLabel(new ImageIcon(this.food_image), 0);
        this.hunter = new JLabel(new ImageIcon(this.hunter_image), 0);
        this.hunter.setVerticalTextPosition(3);
        this.hunter.setHorizontalTextPosition(0);
        this.prey = new JLabel(new ImageIcon(this.prey_image), 0);
        this.prey.setVerticalTextPosition(3);
        this.prey.setHorizontalTextPosition(0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                MapPanel.this.rescale = true;
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void update(CurrentVision cv) {
        this.cv = cv;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        int i;
        if (this.cv == null) {
            g.setColor(Color.BLACK);
            g.drawString("No vision!", this.getBounds().width / 2, this.getBounds().height / 2);
            return;
        }
        int worldwidth = this.cv.getCreature().getWorldWidth();
        int worldheight = this.cv.getCreature().getWorldHeight();
        Rectangle bounds = this.getBounds();
        double cellw = bounds.getWidth() / (double)worldwidth;
        double cellh = bounds.getHeight() / (double)worldheight;
        if (this.rescale) {
            ((ImageIcon)this.obstacle.getIcon()).setImage(this.obstacle_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.food.getIcon()).setImage(this.food_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.hunter.getIcon()).setImage(this.hunter_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.prey.getIcon()).setImage(this.prey_image.getScaledInstance((int)cellw, (int)cellh, 1));
            this.rescale = false;
        }
        Image image = this.background_image;
        int w = image.getWidth(this);
        int h = image.getHeight(this);
        if (w > 0 && h > 0) {
            for (int y = 0; y < bounds.height; y += h) {
                for (int x = 0; x < bounds.width; x += w) {
                    g.drawImage(image, x, y, this);
                }
            }
        }
        WorldObject[] objects = this.cv.getVision().getObjects();
        for (int i2 = 0; i2 < objects.length; ++i2) {
            if (!(objects[i2] instanceof Obstacle) && !(objects[i2] instanceof Food)) continue;
            this.renderObject(g, objects[i2], cellw, cellh);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        for (double x = 0.0; x < (double)bounds.width; x += cellw) {
            g.drawLine((int)x, 0, (int)x, bounds.height - 1);
        }
        for (double y = 0.0; y < (double)bounds.height; y += cellh) {
            g.drawLine(0, (int)y, bounds.width - 1, (int)y);
        }
        for (i = 0; i < objects.length; ++i) {
            int j;
            if (!(objects[i] instanceof Creature)) continue;
            double lifeness = (double)((Creature)objects[i]).getLeaseticks() / (double)Environment.DEFAULT_LEASE_TICKS;
            int vision = ((Creature)objects[i]).getVisionRange();
            Location loc = objects[i].getLocation();
            g.setColor(new Color(255, 255, 0, (int)(64.0 * lifeness)));
            for (j = 1; j <= vision; ++j) {
                g.fillRect((int)(cellw * (double)(loc.getX() - j)), (int)(cellh * (double)(loc.getY() - j)), (int)(cellw * (double)(j * 2 + 1)), (int)(cellh * (double)(j * 2 + 1)));
            }
            if (loc.getX() < vision) {
                for (j = 1; j <= vision; ++j) {
                    g.fillRect((int)(cellw * (double)(loc.getX() - j + worldwidth)), (int)(cellh * (double)(loc.getY() - j)), (int)(cellw * (double)(j * 2 + 1)), (int)(cellh * (double)(j * 2 + 1)));
                }
            } else if (loc.getX() >= worldwidth - vision) {
                for (j = 1; j <= vision; ++j) {
                    g.fillRect((int)(cellw * (double)(loc.getX() - j - worldwidth)), (int)(cellh * (double)(loc.getY() - j)), (int)(cellw * (double)(j * 2 + 1)), (int)(cellh * (double)(j * 2 + 1)));
                }
            }
            if (loc.getY() < vision) {
                for (j = 1; j <= vision; ++j) {
                    g.fillRect((int)(cellw * (double)(loc.getX() - j + worldheight)), (int)(cellh * (double)(loc.getY() - j)), (int)(cellw * (double)(j * 2 + 1)), (int)(cellh * (double)(j * 2 + 1)));
                }
                continue;
            }
            if (loc.getY() < worldheight - vision) continue;
            for (j = 1; j <= vision; ++j) {
                g.fillRect((int)(cellw * (double)(loc.getX() - j - worldheight)), (int)(cellh * (double)(loc.getY() - j)), (int)(cellw * (double)(j * 2 + 1)), (int)(cellh * (double)(j * 2 + 1)));
            }
        }
        for (i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof Creature)) continue;
            this.renderObject(g, objects[i], cellw, cellh);
        }
    }

    protected void renderObject(Graphics g, WorldObject obj, double cellw, double cellh) {
        JLabel comp;
        Location loc = obj.getLocation();
        if (obj instanceof Obstacle) {
            comp = this.obstacle;
        } else if (obj instanceof Food) {
            comp = this.food;
        } else if (obj instanceof Hunter) {
            comp = this.hunter;
        } else if (obj instanceof Prey) {
            comp = this.prey;
        } else {
            if (obj instanceof Observer) {
                return;
            }
            throw new RuntimeException("Unknown type of object: " + obj);
        }
        double lifeness = 1.0;
        if (obj instanceof Creature) {
            lifeness = (double)((Creature)obj).getLeaseticks() / (double)Environment.DEFAULT_LEASE_TICKS;
        }
        SGUI.renderObject((Graphics)g, (Component)comp, (double)cellw, (double)cellh, (int)loc.getX(), (int)loc.getY(), (int)1);
        if (obj instanceof Creature) {
            Creature creature = (Creature)obj;
            comp = new JLabel(creature.getName() + " " + creature.getAge() + " " + creature.getPoints());
            Color col = comp.getForeground();
            ((Component)comp).setForeground(new Color(col.getRed(), col.getGreen(), col.getBlue(), (int)(255.0 * lifeness)));
            Dimension d = ((Component)comp).getPreferredSize();
            Rectangle bounds = new Rectangle((int)(cellw * ((double)loc.getX() + 0.5)) - d.width / 2, (int)(cellh * ((double)loc.getY() + 1.5)) - d.height / 2, d.width + 1, d.height);
            comp.setBounds(bounds);
            g.translate(bounds.x, bounds.y);
            ((Component)comp).paint(g);
            g.translate(-bounds.x, -bounds.y);
        }
    }

    public String getToolTipText(MouseEvent event) {
        if (this.cv == null) {
            return this.getToolTipText();
        }
        int worldwidth = this.cv.getCreature().getWorldWidth();
        int worldheight = this.cv.getCreature().getWorldHeight();
        Rectangle bounds = this.getBounds();
        double cellw = bounds.getWidth() / (double)worldwidth;
        double cellh = bounds.getHeight() / (double)worldheight;
        int x = (int)((double)event.getX() / cellw);
        int y = (int)((double)event.getY() / cellh);
        return "(" + x + "," + y + ")";
    }

    public static void main(String[] args) {
        MapPanel mp = new MapPanel();
        Frame f = new Frame();
        f.add("Center", mp);
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
    }
}

