/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.environment;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.CurrentVision;
import jadex.examples.hunterprey.Environment;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.Vision;
import jadex.examples.hunterprey.environment.CreaturePanel;
import jadex.examples.hunterprey.environment.MapPanel;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class EnvironmentGui
extends JFrame {
    protected MapPanel map = new MapPanel();
    protected JLabel roundcnt;
    protected CreaturePanel creatures;
    protected CreaturePanel observers;
    protected CreaturePanel highscore;

    public EnvironmentGui(final IExternalAccess agent) {
        super(agent.getAgentName());
        this.map.setMinimumSize(new Dimension(300, 300));
        this.map.setPreferredSize(new Dimension(600, 600));
        JPanel options = this.createOptionsPanel(agent);
        this.creatures = new CreaturePanel();
        this.observers = new CreaturePanel(true);
        this.highscore = new CreaturePanel();
        JTabbedPane tp = new JTabbedPane();
        tp.addTab("Living creatures", this.creatures);
        tp.addTab("Observers", this.observers);
        tp.addTab("Highscore", this.highscore);
        tp.setMinimumSize(new Dimension(0, 0));
        tp.setPreferredSize(new Dimension(243, 0));
        JPanel east = new JPanel(new BorderLayout());
        east.add("Center", tp);
        east.add("South", options);
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(this.map);
        split.setRightComponent(east);
        split.setResizeWeight(1.0);
        this.getContentPane().add("Center", split);
        this.pack();
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.enableGuiUpdate(agent);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Environment en = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
                Creature[] creatures = en.getCreatures();
                for (int i = 0; i < creatures.length; ++i) {
                    try {
                        IGoal kg = agent.createGoal("ams_destroy_agent");
                        kg.getParameter("agentidentifier").setValue((Object)creatures[i].getAID());
                        agent.dispatchTopLevelGoalAndWait(kg);
                        continue;
                    }
                    catch (GoalFailureException gfe) {
                        // empty catch block
                    }
                }
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ EnvironmentGui access$000(2 x0) {
                return x0.EnvironmentGui.this;
            }
        }, false);
    }

    protected JPanel createOptionsPanel(final IExternalAccess agent) {
        final Environment env = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
        JPanel options = new JPanel(new GridBagLayout());
        options.setBorder(new TitledBorder(new EtchedBorder(1), "Environment Control"));
        this.roundcnt = new JLabel("0");
        final JTextField roundtimetf = new JTextField("" + agent.getBeliefbase().getBelief("roundtime").getFact(), 5);
        roundtimetf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Long val = new Long(roundtimetf.getText());
                agent.getBeliefbase().getBelief("roundtime").setFact((Object)val);
            }
        });
        final JTextField saveintervaltf = new JTextField("" + env.getSaveInterval(), 5);
        saveintervaltf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                env.setSaveInterval(Long.parseLong(saveintervaltf.getText()));
            }
        });
        JButton hs = new JButton("Save highscore");
        hs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                env.saveHighscore();
            }
        });
        final JTextField foodrate = new JTextField("" + env.getFoodrate(), 4);
        foodrate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                env.setFoodrate(Integer.parseInt(foodrate.getText()));
            }
        });
        Insets insets = new Insets(2, 4, 4, 2);
        options.add((Component)new JLabel("Round number:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)this.roundcnt, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)new JLabel("Round time [millis]:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)roundtimetf, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)new JLabel("Autosave highscore [millis, -1 for off]"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)saveintervaltf, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)new JLabel("Food rate [every n ticks]"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)foodrate, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)hs, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return options;
    }

    protected void enableGuiUpdate(IExternalAccess agent) {
        final Environment env = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
        env.addPropertyChangeListener(new PropertyChangeListener(){
            protected Creature dummy = new Prey();

            public void propertyChange(PropertyChangeEvent evt) {
                EnvironmentGui.this.roundcnt.setText("" + env.getWorldAge());
                this.dummy.setWorldWidth(env.getWidth());
                this.dummy.setWorldHeight(env.getHeight());
                Vision vision = new Vision();
                vision.setObjects(env.getAllObjects());
                EnvironmentGui.this.map.update(new CurrentVision(this.dummy, vision));
                EnvironmentGui.this.creatures.update(env.getCreatures());
                EnvironmentGui.this.observers.update(env.getCreatures());
                EnvironmentGui.this.highscore.update(env.getHighscore());
            }
        });
    }
}

