/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.environment;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.Hunter;
import jadex.examples.hunterprey.Observer;
import jadex.examples.hunterprey.environment.MapPanel;
import jadex.util.SGUI;
import jadex.util.SUtil;
import jadex.util.jtable.ObjectTableModel;
import jadex.util.jtable.ResizeableTableHeader;
import jadex.util.jtable.SorterFilterTableModel;
import jadex.util.jtable.VisibilityTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CreaturePanel
extends JPanel {
    protected Creature[] creatures;
    protected ObjectTableModel tablemodel;
    protected JTable table;
    protected ObjectTableModel tablemodel2;
    protected JTable table2;
    protected Icon hunter;
    protected Icon prey;
    protected Icon observer;
    protected boolean obs;

    public CreaturePanel() {
        this(false);
    }

    public CreaturePanel(boolean obs) {
        this.obs = obs;
        Image hunter_image = ((ImageIcon)MapPanel.icons.getIcon("hunter")).getImage();
        Image prey_image = ((ImageIcon)MapPanel.icons.getIcon("prey")).getImage();
        Image observer_image = ((ImageIcon)MapPanel.icons.getIcon("observer")).getImage();
        this.hunter = new ImageIcon(hunter_image.getScaledInstance(20, 20, 1));
        this.prey = new ImageIcon(prey_image.getScaledInstance(20, 20, 1));
        this.observer = new ImageIcon(observer_image.getScaledInstance(20, 20, 1));
        this.tablemodel = !obs ? new ObjectTableModel(new String[]{"Rank", "Type", "Name", "Age", "Points"}) : new ObjectTableModel(new String[]{"No.", "Type", "Name", "Age"});
        this.tablemodel.setColumnClass(Integer.class, 0);
        this.tablemodel.setColumnClass(Icon.class, 1);
        this.tablemodel.setColumnClass(Integer.class, 3);
        if (!obs) {
            this.tablemodel.setColumnClass(Integer.class, 4);
        }
        SorterFilterTableModel tm = new SorterFilterTableModel((TableModel)this.tablemodel);
        VisibilityTableColumnModel colmodel = new VisibilityTableColumnModel();
        ResizeableTableHeader header = new ResizeableTableHeader((TableColumnModel)colmodel);
        header.setIncludeHeaderWidth(true);
        this.table = new JTable((TableModel)tm, (TableColumnModel)colmodel);
        this.table.setFont(new Font("Arial", 0, 14));
        this.table.setRowHeight(this.hunter.getIconHeight() + 4);
        this.table.setShowVerticalLines(false);
        this.table.createDefaultColumnsFromModel();
        this.table.setAutoResizeMode(0);
        this.table.setSelectionMode(0);
        this.table.setTableHeader((JTableHeader)header);
        for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(40);
        }
        this.table.getColumnModel().getColumn(2).setPreferredWidth(75);
        tm.addMouseListener(this.table);
        colmodel.addMouseListener(this.table);
        JScrollPane sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add("Center", sp);
    }

    public CreaturePanel(Creature[] creatures) {
        this();
        this.update(creatures);
    }

    public void update(final Creature[] creatures) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CreaturePanel.this.tablemodel.removeAllRows();
                for (int i = 0; i < creatures.length; ++i) {
                    if (!CreaturePanel.this.obs && !(creatures[i] instanceof Observer)) {
                        CreaturePanel.this.tablemodel.addRow(new Object[]{"" + (i + 1), creatures[i] instanceof Hunter ? CreaturePanel.this.hunter : CreaturePanel.this.prey, creatures[i].getName(), new Integer(creatures[i].getAge()), new Integer(creatures[i].getPoints())}, (Object)creatures[i]);
                    }
                    if (!CreaturePanel.this.obs || !(creatures[i] instanceof Observer)) continue;
                    CreaturePanel.this.tablemodel.addRow(new Object[]{"" + (i + 1), CreaturePanel.this.observer, creatures[i].getName(), new Integer(creatures[i].getAge())}, (Object)creatures[i]);
                }
            }
        });
    }

    public static void main(String[] args) {
        List creatures = new ArrayList();
        try {
            ObjectInputStream is = new ObjectInputStream(SUtil.getResource((String)"highscore.dmp"));
            creatures = SUtil.arrayToList((Object)is.readObject());
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CreaturePanel t = new CreaturePanel(creatures.toArray(new Creature[creatures.size()]));
        JFrame f = new JFrame();
        f.add("Center", t);
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
    }
}

