/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield;

import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.JointField;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class PotentialFrame
extends JFrame {
    JointField jf;
    Location myLoc;
    int toX;
    int toY;
    Location toLoc;
    static final Color[] dScale = new Color[256];

    public PotentialFrame(final IExternalAccess agent, String title) throws HeadlessException {
        super(title);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ PotentialFrame access$000(2 x0) {
                return x0.PotentialFrame.this;
            }
        }, false);
        this.setSize(400, 400);
        this.setBackground(Color.BLACK);
        this.getContentPane().add(new FieldDisplayer());
        this.getContentPane().setBackground(Color.BLACK);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.toLoc = new Location();
    }

    public void update(JointField jf, Location myLoc, int x, int y) {
        this.jf = jf;
        this.myLoc = myLoc;
        this.toX = x;
        this.toY = y;
        this.repaint();
    }

    static {
        int i = 256;
        while (i-- > 0) {
            PotentialFrame.dScale[i] = new Color(0, 0, i);
        }
    }

    final class FieldDisplayer
    extends JComponent {
        FieldDisplayer() {
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (PotentialFrame.this.jf != null) {
                int ny;
                int nx;
                int h;
                int i = PotentialFrame.this.jf.desire.length;
                int j = h = PotentialFrame.this.jf.desire[0].length;
                int ow = this.getWidth() / i;
                int oh = this.getHeight() / j;
                int ow2 = ow / 2 + 1;
                int oh2 = oh / 2 + 1;
                while (i-- > 0) {
                    j = h;
                    while (j-- > 0) {
                        if (PotentialFrame.this.jf.field.obstacles[i][j]) {
                            g.setColor(Color.GREEN);
                            g.fillOval(ow * i, oh * j, ow, oh);
                            continue;
                        }
                        if (!(PotentialFrame.this.jf.desire[i][j] > 0.0)) continue;
                        int d = (int)((PotentialFrame.this.jf.desire[i][j] - PotentialFrame.this.jf.minDesire) * 256.0 / PotentialFrame.this.jf.maxDesire);
                        d = d < 0 ? 0 : d;
                        d = d > 255 ? 255 : d;
                        g.setColor(dScale[d]);
                        g.fillRect(ow * i, oh * j, ow, oh);
                    }
                }
                g.setColor(Color.WHITE);
                g.fillOval(ow * PotentialFrame.this.myLoc.getX(), oh * PotentialFrame.this.myLoc.getY(), ow, oh);
                int tx = PotentialFrame.this.toX;
                int ty = PotentialFrame.this.toY;
                g.setXORMode(Color.BLUE);
                g.drawLine(tx * ow, ty * oh, tx * ow + ow, ty * oh + oh);
                g.drawLine(tx * ow + ow, ty * oh, tx * ow, ty * oh + oh);
                PotentialFrame.this.toLoc.setX(PotentialFrame.this.toX);
                PotentialFrame.this.toLoc.setY(PotentialFrame.this.toY);
                while (PotentialFrame.this.jf.getNearerLocation(PotentialFrame.this.toLoc)) {
                    nx = PotentialFrame.this.toLoc.getX();
                    ny = PotentialFrame.this.toLoc.getY();
                    if (Math.abs(nx - tx) + Math.abs(ny - ty) == 1) {
                        g.drawLine(tx * ow + ow2, ty * oh + oh2, nx * ow + ow2, ny * oh + oh2);
                    }
                    tx = nx;
                    ty = ny;
                }
                nx = PotentialFrame.this.myLoc.getX();
                ny = PotentialFrame.this.myLoc.getY();
                if (Math.abs(nx - tx) + Math.abs(ny - ty) == 1) {
                    g.drawLine(tx * ow + ow2, ty * oh + oh2, nx * ow + ow2, ny * oh + oh2);
                }
            }
        }
    }
}

