/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.Food;
import jadex.examples.hunterprey.Hunter;
import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.Obstacle;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.WorldObject;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.CreatureModel;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.Evaluator;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.FieldModel;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.FoodModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class JointField
extends HashMap {
    final int h;
    final int w;
    final int range;
    final Evaluator ev;
    final HashSet eaten;
    Creature myself;
    int myX;
    int myY;
    int round;
    final FoodModel food;
    public final FieldModel field;
    public final double[][] desire;
    public double maxDesire;
    public double minDesire;

    public JointField(int h, int w, int range, Evaluator ev) {
        this.h = h;
        this.w = w;
        this.range = range;
        this.ev = ev;
        this.round = 0;
        this.eaten = new HashSet();
        this.desire = new double[w][h];
        this.field = new FieldModel(w, h);
        this.food = new FoodModel(w, h);
    }

    public void add(Creature creature) {
        CreatureModel f = (CreatureModel)this.get(creature);
        if (f == null) {
            f = new CreatureModel(creature, this.w, this.h);
            this.put(creature, f);
        } else {
            this.eaten.remove(creature);
        }
        Location loc = creature.getLocation();
        f.update(loc.getX(), loc.getY(), this.round);
    }

    public void add(Food f) {
        Location loc = f.getLocation();
        int[] nArray = this.food.food[loc.getX()];
        int n = loc.getY();
        nArray[n] = (int)((double)nArray[n] + 1.0);
    }

    public void add(Obstacle o) {
        Location loc = o.getLocation();
        this.field.obstacles[loc.getX()][loc.getY()] = true;
    }

    public void add(WorldObject wo) {
        if (wo instanceof Creature) {
            this.add((Creature)wo);
        } else if (wo instanceof Obstacle) {
            this.add((Obstacle)wo);
        } else if (wo instanceof Food) {
            this.add((Food)wo);
        }
    }

    public void update(WorldObject[] w, Creature myself) {
        Location myLoc = myself.getLocation();
        this.myX = myLoc.getX();
        this.myY = myLoc.getY();
        this.food.clearRange(this.myX, this.myY, this.range);
        this.field.clearRange(this.myX, this.myY, this.range, this.round);
        int i = w.length;
        while (i-- > 0) {
            WorldObject wo = w[i];
            if (myself.equals(wo)) continue;
            this.add(wo);
        }
        ++this.round;
        this.field.calcDistance(this.myX, this.myY);
        this.calcDesire();
    }

    public void eaten(Creature c) {
        this.eaten.add(c);
    }

    public Location getBestLocation() {
        double best = this.desire[this.myX][this.myY];
        int bx = this.myX;
        int by = this.myY;
        int i = this.w;
        while (i-- > 0) {
            int j = this.h;
            while (j-- > 0) {
                double q;
                if (this.field.obstacles[i][j] || !((q = this.desire[i][j] + (double)(0.01f * (float)(this.w * this.h - this.field.distance[i][j]) / (float)this.w * (float)this.h)) > best)) continue;
                best = q;
                bx = i;
                by = j;
            }
        }
        return new Location(bx, by);
    }

    public boolean getNearerLocation(Location loc) {
        return this.field.getNearerLocation(loc);
    }

    public void calcDesire() {
        int i = this.w;
        while (i-- > 0) {
            int j = this.h;
            while (j-- > 0) {
                if (this.field.obstacles[i][j]) {
                    this.desire[i][j] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                this.desire[i][j] = this.ev.food * (double)this.food.food[i][j] + this.ev.explore * (double)Math.min(this.round - this.field.visits[i][j], this.w * this.h);
            }
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            CreatureModel m = (CreatureModel)this.get(o);
            if (this.eaten.contains(m.c)) continue;
            if (m.c instanceof Hunter) {
                this.addModel(this.ev.hunter, m);
                continue;
            }
            if (!(m.c instanceof Prey)) continue;
            this.addModel(this.ev.prey, m);
        }
        this.maxDesire = 0.0;
        this.minDesire = Double.MAX_VALUE;
        int i2 = this.w;
        while (i2-- > 0) {
            int j = this.h;
            while (j-- > 0) {
                double d = this.desire[i2][j];
                if (d > this.maxDesire) {
                    this.maxDesire = d;
                }
                if (!(d < this.minDesire) || !(d >= 0.0)) continue;
                this.minDesire = d;
            }
        }
    }

    protected void addModel(double factor, CreatureModel model) {
        int i = this.w;
        while (i-- > 0) {
            int j = this.h;
            while (j-- > 0) {
                if (this.field.obstacles[i][j]) continue;
                double[] dArray = this.desire[i];
                int n = j;
                dArray[n] = dArray[n] + factor * model.getProbability(i, j, this.round);
            }
        }
    }
}

