/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield;

import jadex.examples.hunterprey.Location;

public final class FieldModel {
    final int w;
    final int h;
    public final boolean[][] obstacles;
    public final int[][] visits;
    final int[][] distance;

    public FieldModel(int w, int h) {
        this.w = w;
        this.h = h;
        this.obstacles = new boolean[w][h];
        this.distance = new int[w][h];
        this.visits = new int[w][h];
    }

    public final boolean getNearerLocation(Location loc) {
        int ix = loc.getX();
        int iy = loc.getY();
        int ox = ix;
        int oy = iy;
        double height = this.distance[ix][iy];
        if (height < 0.0) {
            return false;
        }
        if ((double)this.distance[(ix + 1) % this.w][iy] < height) {
            height = this.distance[(ix + 1) % this.w][iy];
            ox = (ix + 1) % this.w;
            oy = iy;
        }
        if ((double)this.distance[(ix + this.w - 1) % this.w][iy] < height) {
            height = this.distance[(ix + this.w - 1) % this.w][iy];
            ox = (ix + this.w - 1) % this.w;
            oy = iy;
        }
        if ((double)this.distance[ix][(iy + 1) % this.h] < height) {
            height = this.distance[ix][(iy + 1) % this.h];
            ox = ix;
            oy = (iy + 1) % this.h;
        }
        if ((double)this.distance[ix][(iy + this.h - 1) % this.h] < height) {
            ox = ix;
            oy = (iy + this.h - 1) % this.h;
        }
        loc.setX(ox);
        loc.setY(oy);
        return ox != ix || oy != iy;
    }

    public void calcDistance(int mx, int my) {
        this.clearDistance();
        this.distance[mx][my] = 0;
        this.goR(mx, my, 1);
        this.goD(mx, my, 1);
        this.goL(mx, my, 1);
        this.goU(mx, my, 1);
    }

    protected final int goR(int x, int y, int d) {
        if (this.obstacles[x = (x + 1) % this.w][y]) {
            this.distance[x][y] = 0x7FFFFFFD;
            return 0x7FFFFFFD;
        }
        int step = d + 1;
        if (this.distance[x][y] > d) {
            this.distance[x][y] = d;
            int reverse = this.goD(x, y, step);
            if (reverse + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goR(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goU(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
        }
        return this.distance[x][y];
    }

    protected final int goD(int x, int y, int d) {
        if (this.obstacles[x][y = (y + 1) % this.h]) {
            this.distance[x][y] = 0x7FFFFFFD;
            return 0x7FFFFFFD;
        }
        int step = d + 1;
        if (this.distance[x][y] > d) {
            this.distance[x][y] = d;
            int reverse = this.goL(x, y, step);
            if (reverse + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goD(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goR(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
        }
        return this.distance[x][y];
    }

    protected final int goL(int x, int y, int d) {
        if (this.obstacles[x = (x + this.w - 1) % this.w][y]) {
            this.distance[x][y] = 0x7FFFFFFD;
            return 0x7FFFFFFD;
        }
        int step = d + 1;
        if (this.distance[x][y] > d) {
            this.distance[x][y] = d;
            int reverse = this.goU(x, y, step);
            if (reverse + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goL(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goD(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
        }
        return this.distance[x][y];
    }

    protected final int goU(int x, int y, int d) {
        if (this.obstacles[x][y = (y + this.h - 1) % this.h]) {
            this.distance[x][y] = 0x7FFFFFFD;
            return 0x7FFFFFFD;
        }
        int step = d + 1;
        if (this.distance[x][y] > d) {
            this.distance[x][y] = d;
            int reverse = this.goR(x, y, step);
            if (reverse + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goU(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
            if ((reverse = this.goL(x, y, step)) + 1 < this.distance[x][y]) {
                this.distance[x][y] = reverse + 1;
                step = reverse + 2;
            }
        }
        return this.distance[x][y];
    }

    public void clearDistance() {
        int i = this.w;
        while (i-- > 0) {
            int j = this.h;
            while (j-- > 0) {
                this.distance[i][j] = 0x7FFFFFFD;
            }
        }
    }

    public void clearRange(int x, int y, int r, int round) {
        for (int i = x - r; i <= x + r; ++i) {
            for (int j = y - r; j <= y + r; ++j) {
                this.visits[(i + this.w) % this.w][(j + this.h) % this.h] = round;
            }
        }
    }
}

