/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.hunters.ldahunter;

import jadex.examples.hunterprey.Hunter;
import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.Vision;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.JointField;
import jadex.examples.hunterprey.creature.hunters.ldahunter.potentialfield.PotentialFrame;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;

public class HuntPlan
extends Plan {
    Hunter myself;
    Location myLoc;
    JointField jf;
    PotentialFrame pf;
    Vision vis;
    Prey prey;

    public void body() {
        this.vis = (Vision)this.getBeliefbase().getBelief("vision").getFact();
        while (this.vis == null) {
            this.waitFor(500L);
            this.vis = (Vision)this.getBeliefbase().getBelief("vision").getFact();
        }
        this.myself = (Hunter)this.getBeliefbase().getBelief("my_self").getFact();
        this.myLoc = this.myself.getLocation();
        this.jf = (JointField)this.getBeliefbase().getBelief("potential_field").getFact();
        this.pf = (PotentialFrame)this.getBeliefbase().getBelief("potential_window").getFact();
        this.prey = (Prey)this.getBeliefbase().getBelief("next_sheep").getFact();
        this.jf.update(this.vis.getObjects(), this.myself);
        if (!this.eating()) {
            this.foolAround();
        }
    }

    protected boolean eating() {
        if (this.prey != null && this.prey.getLocation().equals(this.myLoc)) {
            IGoal eat = this.createGoal("eat");
            eat.getParameter("object").setValue((Object)this.prey);
            this.jf.eaten(this.prey);
            this.pf.update(this.jf, this.myLoc, this.myLoc.getX(), this.myLoc.getY());
            this.dispatchSubgoalAndWait(eat);
            return true;
        }
        return false;
    }

    protected void foolAround() {
        String[] dirs;
        String dir = null;
        Location to = this.prey != null ? this.prey.getLocation() : this.jf.getBestLocation();
        this.pf.update(this.jf, this.myLoc, to.getX(), to.getY());
        while (this.myself.getDistance(this.myLoc, to) > 1 && this.jf.getNearerLocation(to)) {
        }
        if (this.myself.getDistance(this.myLoc, to) == 1 && (dirs = this.myself.getDirections(this.myLoc, to)).length > 0) {
            dir = dirs[0];
        }
        if (dir == null) {
            String[] posDirs = this.myself.getPossibleDirections(this.vis.getObjects());
            String lastDir = (String)this.getBeliefbase().getBelief("last_direction").getFact();
            dir = posDirs[this.randomInt(posDirs.length)];
            for (int i = 0; i < posDirs.length; ++i) {
                if (lastDir != posDirs[i] || !(Math.random() > 0.2)) continue;
                dir = lastDir;
                break;
            }
        }
        this.getLogger().info("Moving " + dir + " to " + to);
        IGoal move = this.createGoal("move");
        move.getParameter("direction").setValue((Object)dir);
        this.getBeliefbase().getBelief("last_direction").setFact((Object)dir);
        this.dispatchSubgoalAndWait(move);
    }

    int randomInt(int max) {
        int rnd = (int)Math.floor(Math.random() * (double)max);
        return rnd < max ? rnd : max - 1;
    }
}

