/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.hunters.elephunter;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.Hunter;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.Vision;
import jadex.examples.hunterprey.WorldObject;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ELEPHunterPlan
extends Plan {
    protected Random rand = new Random(((Object)((Object)this)).hashCode());

    public void body() {
        this.waitForBeliefChange("vision");
        while (true) {
            Creature me = (Creature)this.getBeliefbase().getBelief("my_self").getFact();
            Vision vision = (Vision)this.getBeliefbase().getBelief("vision").getFact();
            WorldObject[] objects = vision.getObjects();
            me.sortByDistance(objects);
            String[] posdirs = me.getPossibleDirections(objects);
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            for (int i = 0; i < posdirs.length; ++i) {
                values.put(posdirs[i], new Integer(0));
            }
            WorldObject captured = null;
            for (int i = 0; i < objects.length; ++i) {
                int value;
                int j;
                String[] dirs;
                if (!(objects[i] instanceof Hunter) && !(objects[i] instanceof Prey)) continue;
                int good_distance = objects[i] instanceof Hunter ? 3 : 0;
                int dist = me.getDistance(objects[i]);
                if (dist == 0 && objects[i] instanceof Prey) {
                    captured = objects[i];
                    break;
                }
                if (dist > good_distance) {
                    dirs = me.getDirections(objects[i]);
                    for (j = 0; j < dirs.length; ++j) {
                        if (!values.containsKey(dirs[j])) continue;
                        value = (Integer)values.get(dirs[j]);
                        values.put(dirs[j], new Integer(value + 1));
                    }
                    continue;
                }
                if (dist >= good_distance) continue;
                dirs = me.getDirections(objects[i]);
                for (j = 0; j < dirs.length; ++j) {
                    if (!values.containsKey(dirs[j])) continue;
                    value = (Integer)values.get(dirs[j]);
                    values.put(dirs[j], new Integer(value - 1));
                }
            }
            if (captured != null) {
                this.eat(captured);
                continue;
            }
            ArrayList<String> best_moves = new ArrayList<String>();
            int best_value = Integer.MIN_VALUE;
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                String move = (String)i.next();
                int value = (Integer)values.get(move);
                if (value > best_value) {
                    best_value = value;
                    best_moves.clear();
                    best_moves.add(move);
                    continue;
                }
                if (value != best_value) continue;
                best_moves.add(move);
            }
            if (best_moves.size() > 0) {
                this.move((String)best_moves.get(this.rand.nextInt(best_moves.size())));
                continue;
            }
            this.waitForBeliefChange("vision");
        }
    }

    protected void move(String direction) {
        try {
            IGoal move = this.createGoal("move");
            move.getParameter("direction").setValue((Object)direction);
            this.dispatchSubgoalAndWait(move);
        }
        catch (GoalFailureException e) {
            this.getLogger().warning("Move goal failed");
        }
    }

    protected void eat(WorldObject object) {
        try {
            IGoal eat = this.createGoal("eat");
            eat.getParameter("object").setValue((Object)object);
            this.dispatchSubgoalAndWait(eat);
        }
        catch (GoalFailureException e) {
            this.getLogger().warning("Move goal failed");
        }
    }
}

