/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.hunters.dumbhunter;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.Vision;
import jadex.examples.hunterprey.WorldObject;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.util.SUtil;
import java.util.ArrayList;
import java.util.Random;

public class DumbHunterPlan
extends Plan {
    protected Random rand = new Random(((Object)((Object)this)).hashCode());

    public void body() {
        this.waitForBeliefChange("vision");
        while (true) {
            Creature me = (Creature)this.getBeliefbase().getBelief("my_self").getFact();
            Vision vision = (Vision)this.getBeliefbase().getBelief("vision").getFact();
            WorldObject[] objects = vision.getObjects();
            me.sortByDistance(objects);
            String[] posdirs = me.getPossibleDirections(objects);
            int distance = Integer.MAX_VALUE;
            ArrayList<WorldObject> interesting = new ArrayList<WorldObject>();
            for (int i = 0; i < objects.length; ++i) {
                if (!(objects[i] instanceof Prey)) continue;
                int dist = me.getDistance(objects[i]);
                if (dist > distance) break;
                interesting.add(objects[i]);
                distance = dist;
            }
            if (interesting.size() > 0) {
                WorldObject obj = (WorldObject)interesting.get(this.rand.nextInt(interesting.size()));
                String[] dirs = me.getDirections(obj);
                String[] posmoves = (String[])SUtil.cutArrays((Object)dirs, (Object)posdirs);
                if (me.getDistance(obj) == 0) {
                    this.eat(obj);
                    continue;
                }
                if (posmoves.length > 0) {
                    this.move(posmoves[this.rand.nextInt(posmoves.length)]);
                    continue;
                }
                this.move(posdirs[this.rand.nextInt(posdirs.length)]);
                continue;
            }
            this.move(posdirs[this.rand.nextInt(posdirs.length)]);
        }
    }

    protected void move(String direction) {
        try {
            IGoal move = this.createGoal("move");
            move.getParameter("direction").setValue((Object)direction);
            this.dispatchSubgoalAndWait(move);
        }
        catch (GoalFailureException e) {
            this.getLogger().warning("Move goal failed");
        }
    }

    protected void eat(WorldObject object) {
        try {
            IGoal eat = this.createGoal("eat");
            eat.getParameter("object").setValue((Object)object);
            this.dispatchSubgoalAndWait(eat);
        }
        catch (GoalFailureException e) {
            this.getLogger().warning("Move goal failed");
        }
    }
}

