/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey.creature.actsense;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.ServiceDescription;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IBelief;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.runtime.PlanFailureException;

public abstract class RemoteActionPlan
extends Plan {
    public IGoal requestAction(Object action) throws GoalFailureException {
        AgentIdentifier env = this.searchEnvironmentAgent();
        IGoal rg = this.createGoal("rp_initiate");
        rg.getParameter("receiver").setValue((Object)env);
        rg.getParameter("content").setValue(action);
        rg.getParameter("ontology").setValue((Object)"hunterprey_beans");
        this.dispatchSubgoalAndWait(rg);
        return rg;
    }

    public void failed() {
        this.getBeliefbase().getBelief("environmentagent").setFact(null);
    }

    protected AgentIdentifier searchEnvironmentAgent() {
        AgentIdentifier res = (AgentIdentifier)this.getBeliefbase().getBelief("environmentagent").getFact();
        if (res == null) {
            ServiceDescription sd = new ServiceDescription();
            sd.setType("hunter-prey environment");
            AgentDescription dfadesc = new AgentDescription();
            dfadesc.addService(sd);
            IGoal ft = this.createGoal("df_search");
            ft.getParameter("description").setValue((Object)dfadesc);
            IBelief bel = this.getBeliefbase().getBelief("df");
            if (bel.isAccessible()) {
                ft.getParameter("df").setValue(bel.getFact());
            }
            this.dispatchSubgoalAndWait(ft);
            AgentDescription[] tas = (AgentDescription[])ft.getParameterSet("result").getValues();
            if (tas.length != 0) {
                res = tas[0].getName();
                this.getBeliefbase().getBelief("environmentagent").setFact((Object)res);
                if (tas.length > 1) {
                    this.getLogger().warning("More than environment agent found.");
                }
            } else {
                throw new PlanFailureException();
            }
        }
        return res;
    }
}

