/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey;

import jadex.examples.hunterprey.Creature;
import jadex.examples.hunterprey.Food;
import jadex.examples.hunterprey.Hunter;
import jadex.examples.hunterprey.IEnvironment;
import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.Observer;
import jadex.examples.hunterprey.Obstacle;
import jadex.examples.hunterprey.Prey;
import jadex.examples.hunterprey.RequestMove;
import jadex.examples.hunterprey.TaskInfo;
import jadex.examples.hunterprey.Vision;
import jadex.examples.hunterprey.WorldObject;
import jadex.util.SUtil;
import jadex.util.SimplePropertyChangeSupport;
import jadex.util.collection.MultiCollection;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Environment
implements IEnvironment {
    public static int DEFAULT_LEASE_TICKS = 50;
    protected static Environment instance;
    protected Map creatures = new HashMap();
    protected Set obstacles = new HashSet();
    protected Set food = new HashSet();
    public MultiCollection world = new MultiCollection();
    protected int sizex = 30;
    protected int sizey = 30;
    protected Object monitor = new Object();
    protected List tasklist = new ArrayList();
    protected SimplePropertyChangeSupport pcs = new SimplePropertyChangeSupport((Object)this);
    protected Random rand = new Random(12345678L);
    protected List highscore;
    protected long savetime;
    protected long saveinterval = 5000L;
    protected int foodrate = 5;
    protected int age;

    public Environment() {
        int i;
        for (i = 0; i < 125; ++i) {
            this.addObstacle(new Obstacle(this.getEmptyLocation()));
        }
        for (i = 0; i < 10; ++i) {
            this.addFood(new Food(this.getEmptyLocation()));
        }
        try {
            ObjectInputStream is = new ObjectInputStream(SUtil.getResource((String)"highscore.dmp"));
            this.highscore = SUtil.arrayToList((Object)is.readObject());
            is.close();
        }
        catch (Exception e) {
            System.out.println(e);
            this.highscore = new ArrayList();
        }
    }

    public static Environment getInstance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    public boolean moveUp(Creature me) {
        return this.move(me, RequestMove.DIRECTION_UP);
    }

    public boolean moveDown(Creature me) {
        return this.move(me, RequestMove.DIRECTION_DOWN);
    }

    public boolean moveLeft(Creature me) {
        return this.move(me, RequestMove.DIRECTION_LEFT);
    }

    public boolean moveRight(Creature me) {
        return this.move(me, RequestMove.DIRECTION_RIGHT);
    }

    public boolean eat(Creature me, WorldObject food) {
        boolean ret = false;
        int points = 0;
        me = this.getCreature(me);
        me.setLeaseticks(DEFAULT_LEASE_TICKS);
        if (food instanceof Food) {
            if (me.getLocation().equals(food.getLocation())) {
                ret = this.removeFood((Food)food);
                points = 1;
            }
        } else if (me instanceof Hunter && food instanceof Prey) {
            Creature creat = this.getCreature((Creature)food);
            if (me.getLocation().equals(creat.getLocation())) {
                ret = this.removeCreature(creat);
                points = 5;
            }
        }
        if (ret) {
            me.setPoints(me.getPoints() + points);
        }
        return ret;
    }

    public TaskInfo addEatTask(Creature me, WorldObject obj) {
        TaskInfo ret = new TaskInfo(new Object[]{"eat", me, obj});
        this.tasklist.add(ret);
        return ret;
    }

    public TaskInfo addMoveTask(Creature me, String dir) {
        TaskInfo ret = new TaskInfo(new Object[]{"move", me, dir});
        this.tasklist.add(ret);
        return ret;
    }

    public Vision internalGetVision(Creature me) {
        Vision ret = new Vision();
        WorldObject[] wos = (me = this.getCreature(me)) instanceof Observer ? this.getAllObjects() : this.getNearObjects(me.getLocation(), me.getVisionRange());
        ret.setObjects(wos);
        return ret;
    }

    public Vision getVision(Creature me) {
        me = this.getCreature(me);
        me.setLeaseticks(DEFAULT_LEASE_TICKS);
        return this.internalGetVision(me);
    }

    public int getWidth() {
        return this.sizex;
    }

    public int getHeight() {
        return this.sizey;
    }

    public void addFood(Food nfood) {
        this.food.add(nfood);
        this.world.put((Object)nfood.getLocation(), (Object)nfood);
    }

    public boolean removeFood(Food nfood) {
        this.world.remove((Object)nfood.getLocation(), (Object)nfood);
        return this.food.remove(nfood);
    }

    public void addObstacle(Obstacle obstacle) {
        this.obstacles.add(obstacle);
        this.world.put((Object)obstacle.getLocation(), (Object)obstacle);
    }

    public boolean removeObstacle(Obstacle obstacle) {
        this.world.remove((Object)obstacle.getLocation(), (Object)obstacle);
        return this.obstacles.remove(obstacle);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Creature addCreature(Creature creature) {
        void var2_2;
        if (!this.creatures.containsKey(creature)) {
            Creature copy = (Creature)creature.clone();
            copy.setLeaseticks(DEFAULT_LEASE_TICKS);
            copy.setWorldWidth(this.getWidth());
            copy.setWorldHeight(this.getHeight());
            this.creatures.put(copy, copy);
            if (!(copy instanceof Observer)) {
                copy.setAge(0);
                copy.setPoints(0);
                copy.setLocation(this.getEmptyLocation());
                copy.setVisionRange(3);
                this.world.put((Object)copy.getLocation(), (Object)copy);
                this.highscore.add(copy);
            }
        } else {
            throw new RuntimeException("Creature already exists: " + creature);
        }
        return var2_2;
    }

    public synchronized boolean removeCreature(Creature creature) {
        for (int i = 0; i < this.tasklist.size(); ++i) {
            Object[] params = (Object[])((TaskInfo)this.tasklist.get(i)).getAction();
            if (!creature.equals(params[1])) continue;
            this.tasklist.remove(i);
        }
        if (this.world.containsKey((Object)creature.getLocation())) {
            this.world.remove((Object)creature.getLocation(), (Object)creature);
        }
        return this.creatures.remove(creature) != null;
    }

    public void executeStep() {
        Location test;
        Location loc;
        Object[] params;
        int i;
        HashSet<Object> acted = new HashSet<Object>();
        Creature[] creatures = this.getCreatures();
        for (int i2 = 0; i2 < creatures.length; ++i2) {
            creatures[i2].setAge(creatures[i2].getAge() + 1);
            creatures[i2].setLeaseticks(creatures[i2].getLeaseticks() - 1);
            if (creatures[i2].getLeaseticks() >= 0) continue;
            this.removeCreature(creatures[i2]);
        }
        TaskInfo[] tasks = this.tasklist.toArray(new TaskInfo[this.tasklist.size()]);
        for (i = 0; i < tasks.length; ++i) {
            params = (Object[])tasks[i].getAction();
            if (!params[0].equals("eat")) continue;
            if (!acted.contains(params[1])) {
                tasks[i].setResult(new Boolean(this.eat((Creature)params[1], (WorldObject)params[2])));
                acted.add(params[1]);
                continue;
            }
            tasks[i].setResult(new Boolean(false));
        }
        for (i = 0; i < tasks.length; ++i) {
            params = (Object[])tasks[i].getAction();
            if (!params[0].equals("move")) continue;
            if (!acted.contains(params[1])) {
                tasks[i].setResult(new Boolean(this.move((Creature)params[1], (String)params[2])));
                acted.add(params[1]);
                continue;
            }
            tasks[i].setResult(new Boolean(false));
        }
        if (this.age % this.foodrate == 0 && !(loc = this.getEmptyLocation()).equals(test = this.getEmptyLocation())) {
            this.addFood(new Food(loc));
        }
        this.tasklist.clear();
        this.pcs.firePropertyChange("tasklist", null, (Object)this.tasklist);
        long time = System.currentTimeMillis();
        if (this.saveinterval >= 0L && this.savetime + this.saveinterval <= time) {
            this.saveHighscore();
            this.savetime = time;
        }
        ++this.age;
    }

    public int getWorldAge() {
        return this.age;
    }

    public int getFoodrate() {
        return this.foodrate;
    }

    public void setFoodrate(int foodrate) {
        this.foodrate = foodrate;
    }

    public boolean move(Creature me, String dir) {
        boolean ret = true;
        me = this.getCreature(me);
        me.setLeaseticks(DEFAULT_LEASE_TICKS);
        Location newloc = this.createLocation(me.getLocation(), dir);
        Collection col = this.world.getCollection((Object)newloc);
        if (col != null && col.size() == 1 && col.iterator().next() instanceof Obstacle) {
            ret = false;
        } else {
            try {
                this.world.remove((Object)me.getLocation(), (Object)me);
                me.setLocation(newloc);
                this.world.put((Object)me.getLocation(), (Object)me);
            }
            catch (Exception e) {
                System.out.println(this.world + " " + me);
                e.printStackTrace();
            }
        }
        return ret;
    }

    public Creature[] getCreatures() {
        return this.creatures.values().toArray(new Creature[this.creatures.size()]);
    }

    public Obstacle[] getObstacles() {
        return this.obstacles.toArray(new Obstacle[this.obstacles.size()]);
    }

    public Food[] getFood() {
        return this.food.toArray(new Food[this.food.size()]);
    }

    public WorldObject[] getAllObjects() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.obstacles);
        ret.addAll(this.food);
        ret.addAll(this.creatures.values());
        return ret.toArray(new WorldObject[ret.size()]);
    }

    protected Location createLocation(Location loc, String dir) {
        int x = loc.getX();
        int y = loc.getY();
        if (RequestMove.DIRECTION_UP.equals(dir)) {
            y = (this.sizey + y - 1) % this.sizey;
        } else if (RequestMove.DIRECTION_DOWN.equals(dir)) {
            y = (y + 1) % this.sizey;
        } else if (RequestMove.DIRECTION_LEFT.equals(dir)) {
            x = (this.sizex + x - 1) % this.sizex;
        } else if (RequestMove.DIRECTION_RIGHT.equals(dir)) {
            x = (x + 1) % this.sizex;
        }
        return new Location(x, y);
    }

    protected Location getEmptyLocation() {
        Location ret = null;
        while (ret == null) {
            ret = new Location(this.rand.nextInt(this.sizex), this.rand.nextInt(this.sizey));
            if (!this.world.containsKey((Object)ret)) continue;
            ret = null;
        }
        return ret;
    }

    public int getTaskSize() {
        return this.tasklist.size();
    }

    protected Creature getCreature(Creature creature) {
        Creature ret = (Creature)this.creatures.get(creature);
        if (ret == null) {
            ret = this.addCreature(creature);
        }
        return ret;
    }

    protected WorldObject[] getNearObjects(Location loc, int range) {
        ArrayList ret = new ArrayList();
        int x = loc.getX();
        int y = loc.getY();
        for (int i = x - range; i <= x + range; ++i) {
            for (int j = y - range; j <= y + range; ++j) {
                Collection tmp = this.world.getCollection((Object)new Location((i + this.sizex) % this.sizex, (j + this.sizey) % this.sizey));
                if (tmp == null) continue;
                ret.addAll(tmp);
            }
        }
        return ret.toArray(new WorldObject[ret.size()]);
    }

    public synchronized Creature[] getHighscore() {
        Collections.sort(this.highscore, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Creature)o2).getPoints() - ((Creature)o1).getPoints();
            }
        });
        List copy = this.highscore.subList(0, Math.min(this.highscore.size(), 10));
        return copy.toArray(new Creature[copy.size()]);
    }

    public synchronized void saveHighscore() {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream("highscore.dmp"));
            os.writeObject(this.getHighscore());
            os.close();
        }
        catch (Exception e) {
            System.out.println("Error writing hunterprey highscore 'highscore.dmp'.");
        }
    }

    public void setSaveInterval(long saveinterval) {
        this.saveinterval = saveinterval;
    }

    public long getSaveInterval() {
        return this.saveinterval;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

